/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.process;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.process.ProcessInstance;
import org.kie.internal.command.Context;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.NONE)
public class GetProcessInstanceCommand
implements GenericCommand<ProcessInstance> {
    @XmlAttribute(required=true)
    private Long processInstanceId;
    @XmlAttribute
    private boolean readOnly = false;

    public GetProcessInstanceCommand() {
    }

    public GetProcessInstanceCommand(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public Long getProcessInstanceId() {
        return this.processInstanceId;
    }

    public void setProcessInstanceId(Long processInstanceId) {
        this.processInstanceId = processInstanceId;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public ProcessInstance execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        if (this.processInstanceId == null) {
            return null;
        }
        return ksession.getProcessInstance(this.processInstanceId, this.readOnly);
    }

    public String toString() {
        return "session.getProcessInstance(" + this.processInstanceId + ");";
    }
}

