/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.command.runtime.rule;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import org.drools.core.command.IdentifiableResult;
import org.drools.core.command.impl.GenericCommand;
import org.drools.core.command.impl.KnowledgeCommandContext;
import org.drools.core.impl.StatefulKnowledgeSessionImpl;
import org.kie.api.runtime.KieSession;
import org.kie.api.runtime.ObjectFilter;
import org.kie.api.runtime.rule.EntryPoint;
import org.kie.internal.command.Context;

@XmlAccessorType(value=XmlAccessType.NONE)
public class GetObjectsInEntryPointCommand
implements GenericCommand<Collection>,
IdentifiableResult {
    private ObjectFilter filter = null;
    @XmlAttribute(name="out-identifier")
    private String outIdentifier;
    @XmlAttribute(name="entry-point")
    private String entryPoint;

    @Override
    public String getOutIdentifier() {
        return this.outIdentifier;
    }

    @Override
    public void setOutIdentifier(String outIdentifier) {
        this.outIdentifier = outIdentifier;
    }

    public GetObjectsInEntryPointCommand() {
    }

    public GetObjectsInEntryPointCommand(ObjectFilter filter, String entryPoint) {
        this.filter = filter;
        this.entryPoint = entryPoint;
    }

    public GetObjectsInEntryPointCommand(ObjectFilter filter, String entryPoint, String outIdentifier) {
        this.filter = filter;
        this.entryPoint = entryPoint;
        this.outIdentifier = outIdentifier;
    }

    @Override
    public Collection execute(Context context) {
        KieSession ksession = ((KnowledgeCommandContext)context).getKieSession();
        EntryPoint ep = ksession.getEntryPoint(this.entryPoint);
        Collection<? extends Object> col = null;
        col = this.filter != null ? ep.getObjects(this.filter) : ep.getObjects();
        if (this.outIdentifier != null) {
            ArrayList<? extends Object> objects = new ArrayList<Object>(col);
            ((StatefulKnowledgeSessionImpl)ksession).getExecutionResult().getResults().put(this.outIdentifier, objects);
        }
        return col;
    }

    public Collection<? extends Object> getObjects(StatefulKnowledgeSessionImpl session) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(session.getObjectStore(), null, 0);
    }

    public Collection<? extends Object> getObjects(StatefulKnowledgeSessionImpl session, ObjectFilter filter) {
        return new StatefulKnowledgeSessionImpl.ObjectStoreWrapper(session.getObjectStore(), filter, 0);
    }

    public String toString() {
        if (this.filter != null) {
            return "session.getEntryPoint( " + this.entryPoint + " ).iterateObjects( " + this.filter + " );";
        }
        return "session.getEntryPoint( " + this.entryPoint + " ).iterateObjects();";
    }
}

