/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import org.drools.core.io.impl.BaseResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.IoUtils;
import org.kie.api.io.Resource;

public class ByteArrayResource
extends BaseResource
implements InternalResource,
Externalizable {
    private byte[] bytes;
    private String encoding;

    public ByteArrayResource() {
    }

    public ByteArrayResource(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            throw new IllegalArgumentException("bytes cannot be null");
        }
        this.bytes = bytes;
    }

    public ByteArrayResource(byte[] bytes, String encoding) {
        this(bytes);
        this.encoding = encoding;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.bytes = (byte[])in.readObject();
        this.encoding = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.bytes);
        out.writeObject(this.encoding);
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.bytes);
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream(), IoUtils.UTF8_CHARSET);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public boolean hasURL() {
        return false;
    }

    @Override
    public URL getURL() throws IOException {
        throw new FileNotFoundException("byte[] cannot be resolved to URL");
    }

    @Override
    public long getLastModified() {
        throw new IllegalStateException("reader does have a modified date");
    }

    @Override
    public long getLastRead() {
        throw new IllegalStateException("reader does have a modified date");
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    @Override
    public boolean equals(Object object) {
        return object == this || object instanceof ByteArrayResource && Arrays.equals(((ByteArrayResource)object).bytes, this.bytes);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.bytes);
    }

    @Override
    public String toString() {
        return "ByteArrayResource[resource=" + Arrays.toString(this.bytes) + "]";
    }
}

