/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.io.impl.BaseResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class FileSystemResource
extends BaseResource
implements InternalResource,
Externalizable {
    private File file;
    private long lastRead = -1L;
    private String encoding;

    public FileSystemResource() {
    }

    public FileSystemResource(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        this.file = new File(StringUtils.cleanPath(file.getPath()));
        this.setSourcePath(file.getName());
        this.setResourceType(ResourceType.determineResourceType(this.getSourcePath()));
    }

    public FileSystemResource(File file, String encoding) {
        this(file);
        this.encoding = encoding;
    }

    public FileSystemResource(String path) {
        if (path == null) {
            throw new IllegalArgumentException("Path must not be null");
        }
        this.file = new File(StringUtils.cleanPath(path));
        this.setSourcePath(path);
        this.setResourceType(ResourceType.determineResourceType(this.getSourcePath()));
    }

    public FileSystemResource(String path, String encoding) {
        this(path);
        this.encoding = encoding;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.file);
        out.writeObject(this.encoding);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.file = (File)in.readObject();
        this.encoding = (String)in.readObject();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.lastRead = this.getLastModified();
        return new FileInputStream(this.file);
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream(), IoUtils.UTF8_CHARSET);
    }

    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public Collection<Resource> listResources() {
        File[] files = this.file.listFiles();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (File file : files) {
            resources.add(new FileSystemResource(file));
        }
        return resources;
    }

    @Override
    public URL getURL() throws IOException {
        return this.file.toURI().toURL();
    }

    @Override
    public boolean hasURL() {
        return true;
    }

    @Override
    public long getLastModified() {
        long date = this.file.lastModified();
        return date;
    }

    @Override
    public long getLastRead() {
        return this.lastRead;
    }

    @Override
    public String toString() {
        return "FileResource[file=" + this.file.toString() + "]";
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return object == this || object instanceof FileSystemResource && this.file.equals(((FileSystemResource)object).file);
    }

    @Override
    public int hashCode() {
        return this.file.hashCode();
    }
}

