/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.io.impl;

import java.io.Externalizable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.codec.binary.Base64;
import org.drools.core.io.impl.BaseResource;
import org.drools.core.io.impl.FileSystemResource;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.IoUtils;
import org.drools.core.util.StringUtils;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class UrlResource
extends BaseResource
implements InternalResource,
Externalizable {
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    public static final File CACHE_DIR = UrlResource.getCacheDir();
    private URL url;
    private long lastRead = -1L;
    private static final String DROOLS_RESOURCE_URLCACHE = "drools.resource.urlcache";
    private String basicAuthentication = "disabled";
    private String username = "";
    private String password = "";
    private String encoding;
    private static final String DROOLS_RESOURCE_URLTIMEOUT = "drools.resource.urltimeout";
    private static final int DEFAULT_TIMEOUT = 10000;
    private static final int TIMEOUT = UrlResource.initTimeout();

    public UrlResource() {
    }

    public UrlResource(URL url) {
        this.url = this.getCleanedUrl(url, url.toString());
        this.setSourcePath(this.url.getPath());
        this.setResourceType(ResourceType.determineResourceType(this.url.getPath()));
    }

    public UrlResource(URL url, String encoding) {
        this(url);
        this.encoding = encoding;
    }

    public UrlResource(String path) {
        try {
            this.url = this.getCleanedUrl(new URL(path), path);
            this.setSourcePath(this.url.getPath());
            this.setResourceType(ResourceType.determineResourceType(this.url.getPath()));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("'" + path + "' path is malformed", e);
        }
    }

    public UrlResource(String path, String encoding) {
        this(path);
        this.encoding = encoding;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.url);
        out.writeObject(this.encoding);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.url = (URL)in.readObject();
        this.encoding = (String)in.readObject();
    }

    @Override
    public String getEncoding() {
        return this.encoding;
    }

    public String getBasicAuthentication() {
        return this.basicAuthentication;
    }

    public void setBasicAuthentication(String basicAuthentication) {
        this.basicAuthentication = basicAuthentication;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        try {
            long lastMod = this.grabLastMod();
            if (lastMod == 0L && this.cacheFileExists()) {
                return this.fromCache();
            }
            if (lastMod > 0L && lastMod > this.lastRead && CACHE_DIR != null && (this.url.getProtocol().equals("http") || this.url.getProtocol().equals("https"))) {
                this.cacheStream();
                this.lastRead = lastMod = this.getCacheFile().lastModified();
                return this.fromCache();
            }
            this.lastRead = lastMod;
            return this.grabStream();
        }
        catch (IOException e) {
            if (this.cacheFileExists()) {
                return this.fromCache();
            }
            throw e;
        }
    }

    private boolean cacheFileExists() {
        return CACHE_DIR != null && this.getCacheFile().exists();
    }

    private InputStream fromCache() throws FileNotFoundException, UnsupportedEncodingException {
        File fi = this.getCacheFile();
        return new FileInputStream(fi);
    }

    private File getCacheFile() {
        try {
            return new File(CACHE_DIR, URLEncoder.encode(this.url.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private File getTemproralCacheFile() {
        try {
            return new File(CACHE_DIR, URLEncoder.encode(this.url.toString(), "UTF-8") + "_tmp");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void cacheStream() {
        try {
            int n;
            File fi = this.getTemproralCacheFile();
            if (fi.exists()) {
                fi.delete();
            }
            FileOutputStream fout = new FileOutputStream(fi);
            InputStream in = this.grabStream();
            byte[] buffer = new byte[4096];
            while (-1 != (n = in.read(buffer))) {
                fout.write(buffer, 0, n);
            }
            fout.flush();
            fout.close();
            in.close();
            File cacheFile = this.getCacheFile();
            fi.renameTo(cacheFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private URLConnection openURLConnection(URL url) throws IOException {
        URLConnection con = url.openConnection();
        con.setConnectTimeout(TIMEOUT);
        con.setReadTimeout(TIMEOUT);
        return con;
    }

    private InputStream grabStream() throws IOException {
        URLConnection con = this.openURLConnection(this.url);
        con.setUseCaches(false);
        if (con instanceof HttpURLConnection && "enabled".equalsIgnoreCase(this.basicAuthentication)) {
            String userpassword = this.username + ":" + this.password;
            byte[] authEncBytes = Base64.encodeBase64((byte[])userpassword.getBytes(IoUtils.UTF8_CHARSET));
            ((HttpURLConnection)con).setRequestProperty("Authorization", "Basic " + new String(authEncBytes, IoUtils.UTF8_CHARSET));
        }
        return con.getInputStream();
    }

    @Override
    public Reader getReader() throws IOException {
        if (this.encoding != null) {
            return new InputStreamReader(this.getInputStream(), this.encoding);
        }
        return new InputStreamReader(this.getInputStream(), IoUtils.UTF8_CHARSET);
    }

    private URL getCleanedUrl(URL originalUrl, String originalPath) {
        try {
            return new URL(StringUtils.cleanPath(originalPath));
        }
        catch (MalformedURLException ex) {
            return originalUrl;
        }
    }

    @Override
    public URL getURL() throws IOException {
        return this.url;
    }

    @Override
    public boolean hasURL() {
        return true;
    }

    public File getFile() throws IOException {
        try {
            return new File(StringUtils.toURI(this.url.toString()).getSchemeSpecificPart());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get File for url " + this.url, e);
        }
    }

    @Override
    public long getLastModified() {
        try {
            long lm = this.grabLastMod();
            if (lm == 0L && this.cacheFileExists()) {
                return this.getCacheFile().lastModified();
            }
            return lm;
        }
        catch (IOException e) {
            if (this.cacheFileExists()) {
                return this.getCacheFile().lastModified();
            }
            throw new RuntimeException("Unable to get LastModified for ClasspathResource", e);
        }
    }

    private long grabLastMod() throws IOException {
        long date;
        if ("file".equals(this.url.getProtocol())) {
            File file = this.getFile();
            return file.lastModified();
        }
        URLConnection conn = this.openURLConnection(this.getURL());
        if (conn instanceof HttpURLConnection) {
            ((HttpURLConnection)conn).setRequestMethod("HEAD");
            if ("enabled".equalsIgnoreCase(this.basicAuthentication)) {
                String userpassword = this.username + ":" + this.password;
                byte[] authEncBytes = Base64.encodeBase64((byte[])userpassword.getBytes(IoUtils.UTF8_CHARSET));
                ((HttpURLConnection)conn).setRequestProperty("Authorization", "Basic " + new String(authEncBytes, IoUtils.UTF8_CHARSET));
            }
        }
        if ((date = conn.getLastModified()) == 0L) {
            try {
                date = Long.parseLong(conn.getHeaderField("lastModified"));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return date;
    }

    @Override
    public long getLastRead() {
        return this.lastRead;
    }

    @Override
    public boolean isDirectory() {
        try {
            URL url = this.getURL();
            if ("file".equals(url.getProtocol())) {
                File file = new File(StringUtils.toURI(url.toString()).getSchemeSpecificPart());
                return file.isDirectory();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    @Override
    public Collection<Resource> listResources() {
        try {
            URL url = this.getURL();
            if ("file".equals(url.getProtocol())) {
                File dir = this.getFile();
                ArrayList<Resource> resources = new ArrayList<Resource>();
                for (File file : dir.listFiles()) {
                    resources.add(new FileSystemResource(file));
                }
                return resources;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("This Resource cannot be listed, or is not a directory");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        return obj == this || obj instanceof UrlResource && this.url.equals(((UrlResource)obj).url);
    }

    @Override
    public int hashCode() {
        return this.url.hashCode();
    }

    @Override
    public String toString() {
        return "UrlResource[path=" + this.url.toString() + "]";
    }

    private static File getCacheDir() {
        String root = System.getProperty(DROOLS_RESOURCE_URLCACHE, "NONE");
        if (root.equals("NONE")) {
            return null;
        }
        return new File(root);
    }

    private static int initTimeout() {
        try {
            return Integer.parseInt(System.getProperty(DROOLS_RESOURCE_URLTIMEOUT));
        }
        catch (Exception e) {
            return 10000;
        }
    }
}

