/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.runtime.rule.impl;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.drools.core.QueryResultsImpl;
import org.drools.core.QueryResultsRowImpl;
import org.drools.core.rule.Declaration;
import org.drools.core.runtime.rule.impl.FlatQueryResultRow;
import org.drools.core.xml.jaxb.util.JaxbFlatQueryResultsAdapter;
import org.drools.core.xml.jaxb.util.JaxbMapAdapter;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.QueryResults;
import org.kie.api.runtime.rule.QueryResultsRow;

@XmlAccessorType(value=XmlAccessType.FIELD)
@XmlType(name="query-results")
@XmlRootElement
public class FlatQueryResults
implements QueryResults {
    @XmlJavaTypeAdapter(value=JaxbMapAdapter.class)
    @XmlElement(name="identifiers")
    private Map<String, Integer> identifiers;
    @XmlElement(name="results")
    @XmlJavaTypeAdapter(value=JaxbFlatQueryResultsAdapter.class)
    private ArrayList<ArrayList<Object>> results;
    @XmlJavaTypeAdapter(value=JaxbFlatQueryResultsAdapter.class)
    @XmlElement(name="fact-handles")
    private ArrayList<ArrayList<FactHandle>> factHandles;

    public FlatQueryResults() {
    }

    public FlatQueryResults(Map<String, Integer> identifiers, ArrayList<ArrayList<Object>> results, ArrayList<ArrayList<FactHandle>> factHandles) {
        this.identifiers = identifiers;
        this.results = results;
        this.factHandles = factHandles;
    }

    public FlatQueryResults(QueryResultsImpl results) {
        Declaration[] parameters = results.getParameters();
        HashSet<String> set = new HashSet<String>();
        for (Declaration declr : parameters) {
            set.add(declr.getIdentifier());
        }
        ArrayList<Declaration> declrCollection = new ArrayList<Declaration>(results.getDeclarations(0).values());
        Iterator it = declrCollection.iterator();
        while (it.hasNext()) {
            Declaration declr = (Declaration)it.next();
            if (!set.contains(declr.getIdentifier())) continue;
            it.remove();
        }
        Declaration[] declrs = new Declaration[parameters.length + declrCollection.size()];
        int i = 0;
        for (Declaration declr : parameters) {
            declrs[i++] = declr;
        }
        for (Declaration declr : declrCollection) {
            declrs[i++] = declr;
        }
        this.results = new ArrayList(results.size());
        this.factHandles = new ArrayList(results.size());
        int length = declrs.length;
        this.identifiers = new LinkedHashMap<String, Integer>(length);
        for (i = 0; i < length; ++i) {
            this.identifiers.put(declrs[i].getIdentifier(), i);
        }
        for (QueryResultsRow result : results) {
            ArrayList<Object> row = new ArrayList<Object>();
            ArrayList<FactHandle> rowHandle = new ArrayList<FactHandle>();
            for (i = 0; i < length; ++i) {
                Declaration declr = declrs[i];
                row.add(((QueryResultsRowImpl)result).get(declr));
                rowHandle.add(((QueryResultsRowImpl)result).getFactHandle(declr));
            }
            this.results.add(row);
            this.factHandles.add(rowHandle);
        }
    }

    @Override
    public String[] getIdentifiers() {
        return this.identifiers.keySet().toArray(new String[this.identifiers.size()]);
    }

    @Override
    public int size() {
        return this.results.size();
    }

    @Override
    public Iterator<QueryResultsRow> iterator() {
        return new QueryResultsIterator(this.identifiers, this.results.iterator(), this.factHandles.iterator());
    }

    private class QueryResultsIterator
    implements Iterator<QueryResultsRow> {
        private Map<String, Integer> identifiers;
        private Iterator<ArrayList<Object>> iterator;
        private Iterator<ArrayList<FactHandle>> handleIterator;

        public QueryResultsIterator(Map<String, Integer> identifiers, Iterator<ArrayList<Object>> iterator, Iterator<ArrayList<FactHandle>> handleIterator) {
            this.identifiers = identifiers;
            this.iterator = iterator;
            this.handleIterator = handleIterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public QueryResultsRow next() {
            return new FlatQueryResultRow(this.identifiers, this.iterator.next(), (List<FactHandle>)this.handleIterator.next());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

