/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.asm;

import java.util.List;
import org.mvel2.asm.AnnotationVisitor;
import org.mvel2.asm.Attribute;
import org.mvel2.asm.ClassReader;
import org.mvel2.asm.ClassVisitor;
import org.mvel2.asm.FieldVisitor;
import org.mvel2.asm.MethodVisitor;
import org.mvel2.asm.util.Printer;
import org.mvel2.asm.util.Textifier;
import org.mvel2.asm.util.TraceMethodVisitor;

public class MethodComparator {
    public boolean equivalent(String method1, ClassReader class1, String method2, ClassReader class2) {
        List list1 = this.getMethodBytecode(method1, class1);
        List list2 = this.getMethodBytecode(method2, class2);
        return MethodComparator.compareBytecode(list1, list2);
    }

    public List getMethodBytecode(String methodName, ClassReader classReader) {
        Tracer visit = new Tracer(methodName);
        classReader.accept(visit, 2);
        return visit.getText();
    }

    public static List getMethodBytecode(String methodName, byte[] bytes) {
        Tracer visit = new Tracer(methodName);
        ClassReader classReader = new ClassReader(bytes);
        classReader.accept(visit, 2);
        return visit.getText();
    }

    public static boolean compareBytecode(List b1, List b2) {
        if (b1.size() != b2.size()) {
            return false;
        }
        for (int i = 0; i < b1.size(); ++i) {
            if (b1.get(i).equals(b2.get(i))) continue;
            return false;
        }
        return true;
    }

    static class DummyAnnotationVisitor
    extends AnnotationVisitor {
        public DummyAnnotationVisitor() {
            super(327680);
        }

        @Override
        public void visit(String name, Object value) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String name, String desc) {
            return new DummyAnnotationVisitor();
        }

        @Override
        public AnnotationVisitor visitArray(String name) {
            return new DummyAnnotationVisitor();
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitEnum(String name, String desc, String value) {
        }
    }

    public static class Tracer
    extends ClassVisitor {
        private TraceMethodVisitor trace;
        private String methodName;
        private Printer printer;

        public Tracer(String methodName) {
            super(327680);
            this.methodName = methodName;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            return new DummyAnnotationVisitor();
        }

        @Override
        public void visitAttribute(Attribute attr) {
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            return null;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        @Override
        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.methodName.equals(name)) {
                this.printer = new Textifier();
                this.trace = new TraceMethodVisitor(this.printer);
                return this.trace;
            }
            return null;
        }

        @Override
        public void visitOuterClass(String owner, String name, String desc) {
        }

        @Override
        public void visitSource(String source, String debug) {
        }

        public List<Object> getText() {
            return this.printer.getText();
        }
    }
}

