/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import org.kie.internal.assembler.KieAssemblerService;
import org.kie.internal.assembler.KieAssemblers;
import org.kie.internal.runtime.KieRuntimeService;
import org.kie.internal.runtime.KieRuntimes;
import org.kie.internal.runtime.beliefs.KieBeliefService;
import org.kie.internal.runtime.beliefs.KieBeliefs;
import org.kie.internal.utils.ClassLoaderUtil;
import org.kie.internal.utils.KieService;
import org.kie.internal.utils.ServiceRegistry;
import org.kie.internal.utils.ServiceRegistryImpl;
import org.kie.internal.weaver.KieWeaverService;
import org.kie.internal.weaver.KieWeavers;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceDiscovery {
    private static final Logger log = LoggerFactory.getLogger(ServiceDiscovery.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void discoverFactories(String path, ServiceRegistry serviceRegistry) {
        Enumeration<URL> e;
        ClassLoader classLoader = ServiceDiscovery.getClassLoader();
        ArrayList list = new ArrayList();
        try {
            e = classLoader.getResources(path);
        }
        catch (IOException exc) {
            log.error("Unable to find and build kie service for url={}\n message={} ", (Object)path, (Object)exc.getMessage());
            return;
        }
        while (e.hasMoreElements()) {
            URL url = e.nextElement();
            InputStream is = null;
            try {
                is = url.openStream();
                log.info("Discovered kie.conf url={} ", (Object)url);
                ServiceDiscovery.processKieConf(is, serviceRegistry);
            }
            catch (Exception exc) {
                log.error("Unable to build kie service url={} reason={}\n", (Object)url.toExternalForm(), (Object)exc.getMessage());
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                        continue;
                    }
                    log.error("Unable to build kie service url={}\n", (Object)url.toExternalForm());
                }
                catch (IOException e1) {
                    log.warn("Unable to close Stream for url={} reason={}", (Object)url, (Object)e1.getMessage());
                }
            }
        }
    }

    public static void processKieConf(InputStream is, ServiceRegistry serviceRegistry) throws IOException {
        String conf = ServiceDiscovery.readFileAsString(new InputStreamReader(is));
        ServiceDiscovery.processKieConf(conf, serviceRegistry);
    }

    public static void processKieConf(String conf, ServiceRegistry serviceRegistry) {
        Map map = (Map)MVEL.eval(conf);
        ServiceDiscovery.processKieConf(map, serviceRegistry);
    }

    public static void processKieConf(Map map, ServiceRegistry serviceRegistry) {
        ServiceDiscovery.processKieServices(map, serviceRegistry);
        ServiceDiscovery.processKieAssemblers(map, serviceRegistry);
        ServiceDiscovery.processKieWeavers(map, serviceRegistry);
        ServiceDiscovery.processKieBeliefs(map, serviceRegistry);
        ServiceDiscovery.processRuntimes(map, serviceRegistry);
    }

    private static void processRuntimes(Map map, ServiceRegistry serviceRegistry) {
        List runtimeList = (List)map.get("runtimes");
        if (runtimeList != null && runtimeList.size() > 0) {
            KieRuntimes runtimes = serviceRegistry.get(KieRuntimes.class);
            for (KieRuntimeService runtime : runtimeList) {
                log.info("Adding Runtime {} ", (Object)runtime.getServiceInterface().getName());
                runtimes.getRuntimes().put(runtime.getServiceInterface().getName(), runtime);
            }
        }
    }

    private static void processKieAssemblers(Map map, ServiceRegistry serviceRegistry) {
        List assemblerList = (List)map.get("assemblers");
        if (assemblerList != null && assemblerList.size() > 0) {
            KieAssemblers assemblers = serviceRegistry.get(KieAssemblers.class);
            for (KieAssemblerService assemblerFactory : assemblerList) {
                log.info("Adding Assembler {} ", (Object)assemblerFactory.getClass().getName());
                assemblers.getAssemblers().put(assemblerFactory.getResourceType(), assemblerFactory);
            }
        }
    }

    private static void processKieWeavers(Map map, ServiceRegistry serviceRegistry) {
        List weaverList = (List)map.get("weavers");
        if (weaverList != null && weaverList.size() > 0) {
            KieWeavers weavers = serviceRegistry.get(KieWeavers.class);
            for (KieWeaverService weaver : weaverList) {
                log.info("Adding Weaver {} ", (Object)weavers.getClass().getName());
                weavers.getWeavers().put(weaver.getResourceType(), weaver);
            }
        }
    }

    private static void processKieBeliefs(Map map, ServiceRegistry serviceRegistry) {
        List beliefsList = (List)map.get("beliefs");
        if (beliefsList != null && beliefsList.size() > 0) {
            KieBeliefs beliefs = serviceRegistry.get(KieBeliefs.class);
            for (KieBeliefService belief : beliefsList) {
                log.info("Adding Belief {} ", (Object)beliefs.getClass().getName());
                beliefs.getBeliefs().put(belief.getBeliefType(), belief);
            }
        }
    }

    private static void processKieServices(Map map, ServiceRegistry serviceRegistry) {
        List servicesList = (List)map.get("services");
        if (servicesList != null && servicesList.size() > 0) {
            for (KieService service : servicesList) {
                log.info("Adding Service {} ", (Object)service.getClass().getName());
                serviceRegistry.registerLocator(service.getServiceInterface(), new ServiceRegistryImpl.ReturnInstance(service));
            }
        }
    }

    public static String readFileAsString(Reader reader) {
        try {
            int numRead;
            StringBuilder fileData = new StringBuilder(1000);
            char[] buf = new char[1024];
            while ((numRead = reader.read(buf)) != -1) {
                String readData = String.valueOf(buf, 0, numRead);
                fileData.append(readData);
                buf = new char[1024];
            }
            reader.close();
            return fileData.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = ClassLoader.getSystemClassLoader();
        }
        if (cl == null) {
            cl = ClassLoaderUtil.class.getClassLoader();
        }
        return cl;
    }
}

