/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.common.nearby;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.SelectorConfig;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.entity.EntitySelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.BetaDistributionNearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.BlockDistributionNearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.LinearDistributionNearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.ParabolicDistributionNearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.nearby.NearEntityNearbyEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.value.ValueSelector;
import org.optaplanner.core.impl.heuristic.selector.value.nearby.NearEntityNearbyValueSelector;

@XStreamAlias(value="nearbySelection")
public class NearbySelectionConfig
extends SelectorConfig {
    @XStreamAlias(value="originEntitySelector")
    protected EntitySelectorConfig originEntitySelectorConfig = null;
    protected Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass = null;
    protected Integer blockDistributionSizeMinimum = null;
    protected Integer blockDistributionSizeMaximum = null;
    protected Double blockDistributionSizeRatio = null;
    protected Double blockDistributionUniformDistributionProbability = null;
    protected Integer linearDistributionSizeMaximum = null;
    protected Integer parabolicDistributionSizeMaximum = null;
    protected Double betaDistributionAlpha = null;
    protected Double betaDistributionBeta = null;

    public EntitySelectorConfig getOriginEntitySelectorConfig() {
        return this.originEntitySelectorConfig;
    }

    public void setOriginEntitySelectorConfig(EntitySelectorConfig originEntitySelectorConfig) {
        this.originEntitySelectorConfig = originEntitySelectorConfig;
    }

    public Class<? extends NearbyDistanceMeter> getNearbyDistanceMeterClass() {
        return this.nearbyDistanceMeterClass;
    }

    public void setNearbyDistanceMeterClass(Class<? extends NearbyDistanceMeter> nearbyDistanceMeterClass) {
        this.nearbyDistanceMeterClass = nearbyDistanceMeterClass;
    }

    public Integer getBlockDistributionSizeMinimum() {
        return this.blockDistributionSizeMinimum;
    }

    public void setBlockDistributionSizeMinimum(Integer blockDistributionSizeMinimum) {
        this.blockDistributionSizeMinimum = blockDistributionSizeMinimum;
    }

    public Integer getBlockDistributionSizeMaximum() {
        return this.blockDistributionSizeMaximum;
    }

    public void setBlockDistributionSizeMaximum(Integer blockDistributionSizeMaximum) {
        this.blockDistributionSizeMaximum = blockDistributionSizeMaximum;
    }

    public Double getBlockDistributionSizeRatio() {
        return this.blockDistributionSizeRatio;
    }

    public void setBlockDistributionSizeRatio(Double blockDistributionSizeRatio) {
        this.blockDistributionSizeRatio = blockDistributionSizeRatio;
    }

    public Double getBlockDistributionUniformDistributionProbability() {
        return this.blockDistributionUniformDistributionProbability;
    }

    public void setBlockDistributionUniformDistributionProbability(Double blockDistributionUniformDistributionProbability) {
        this.blockDistributionUniformDistributionProbability = blockDistributionUniformDistributionProbability;
    }

    public Integer getLinearDistributionSizeMaximum() {
        return this.linearDistributionSizeMaximum;
    }

    public void setLinearDistributionSizeMaximum(Integer linearDistributionSizeMaximum) {
        this.linearDistributionSizeMaximum = linearDistributionSizeMaximum;
    }

    public Integer getParabolicDistributionSizeMaximum() {
        return this.parabolicDistributionSizeMaximum;
    }

    public void setParabolicDistributionSizeMaximum(Integer parabolicDistributionSizeMaximum) {
        this.parabolicDistributionSizeMaximum = parabolicDistributionSizeMaximum;
    }

    public Double getBetaDistributionAlpha() {
        return this.betaDistributionAlpha;
    }

    public void setBetaDistributionAlpha(Double betaDistributionAlpha) {
        this.betaDistributionAlpha = betaDistributionAlpha;
    }

    public Double getBetaDistributionBeta() {
        return this.betaDistributionBeta;
    }

    public void setBetaDistributionBeta(Double betaDistributionBeta) {
        this.betaDistributionBeta = betaDistributionBeta;
    }

    public void validateNearby(SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder) {
        if (this.originEntitySelectorConfig == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") is nearby selection" + " but lacks a nearbyOriginEntitySelector (" + this.originEntitySelectorConfig + ").");
        }
        if (this.nearbyDistanceMeterClass == null) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") is nearby selection" + " but lacks a nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ").");
        }
        if (resolvedSelectionOrder != SelectionOrder.ORIGINAL && resolvedSelectionOrder != SelectionOrder.RANDOM) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") with nearbyOriginEntitySelector (" + this.originEntitySelectorConfig + ") and nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ") has a resolvedSelectionOrder (" + (Object)((Object)resolvedSelectionOrder) + ") that is not " + (Object)((Object)SelectionOrder.ORIGINAL) + " or " + (Object)((Object)SelectionOrder.RANDOM) + ".");
        }
        if (resolvedCacheType.isCached()) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") with nearbyOriginEntitySelector (" + this.originEntitySelectorConfig + ") and nearbyDistanceMeterClass (" + this.nearbyDistanceMeterClass + ") has a resolvedCacheType (" + (Object)((Object)resolvedCacheType) + ") that is cached.");
        }
    }

    public EntitySelector applyNearbyEntitySelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, EntitySelector entitySelector) {
        boolean randomSelection = resolvedSelectionOrder.toRandomSelectionBoolean();
        EntitySelector originEntitySelector = this.originEntitySelectorConfig.buildEntitySelector(configPolicy, minimumCacheType, resolvedSelectionOrder);
        NearbyDistanceMeter nearbyDistanceMeter = ConfigUtils.newInstance(this, "nearbyDistanceMeterClass", this.nearbyDistanceMeterClass);
        NearbyRandom nearbyRandom = this.buildNearbyRandom();
        return new NearEntityNearbyEntitySelector(entitySelector, originEntitySelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
    }

    public ValueSelector applyNearbyValueSelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, SelectionCacheType resolvedCacheType, SelectionOrder resolvedSelectionOrder, ValueSelector valueSelector) {
        boolean randomSelection = resolvedSelectionOrder.toRandomSelectionBoolean();
        EntitySelector originEntitySelector = this.originEntitySelectorConfig.buildEntitySelector(configPolicy, minimumCacheType, resolvedSelectionOrder);
        NearbyDistanceMeter nearbyDistanceMeter = ConfigUtils.newInstance(this, "nearbyDistanceMeterClass", this.nearbyDistanceMeterClass);
        NearbyRandom nearbyRandom = this.buildNearbyRandom();
        return new NearEntityNearbyValueSelector(valueSelector, originEntitySelector, nearbyDistanceMeter, nearbyRandom, randomSelection);
    }

    protected NearbyRandom buildNearbyRandom() {
        boolean betaDistributionEnabled;
        boolean blockDistributionEnabled = this.blockDistributionSizeMinimum != null || this.blockDistributionSizeMaximum != null || this.blockDistributionSizeRatio != null || this.blockDistributionUniformDistributionProbability != null;
        boolean linearDistributionEnabled = this.linearDistributionSizeMaximum != null;
        boolean parabolicDistributionEnabled = this.parabolicDistributionSizeMaximum != null;
        boolean bl = betaDistributionEnabled = this.betaDistributionAlpha != null || this.betaDistributionBeta != null;
        if (blockDistributionEnabled && linearDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has both blockDistribution and linearDistribution parameters.");
        }
        if (blockDistributionEnabled && parabolicDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has both blockDistribution and parabolicDistribution parameters.");
        }
        if (blockDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has both blockDistribution and betaDistribution parameters.");
        }
        if (linearDistributionEnabled && parabolicDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has both linearDistribution and parabolicDistribution parameters.");
        }
        if (linearDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has both linearDistribution and betaDistribution parameters.");
        }
        if (parabolicDistributionEnabled && betaDistributionEnabled) {
            throw new IllegalArgumentException("The nearbySelectorConfig (" + this + ") has both parabolicDistribution and betaDistribution parameters.");
        }
        if (blockDistributionEnabled) {
            int sizeMinimum = this.blockDistributionSizeMinimum == null ? 0 : this.blockDistributionSizeMinimum;
            int sizeMaximum = this.blockDistributionSizeMaximum == null ? Integer.MAX_VALUE : this.blockDistributionSizeMaximum;
            double sizeRatio = this.blockDistributionSizeRatio == null ? 1.0 : this.blockDistributionSizeRatio;
            double uniformDistributionProbability = this.blockDistributionUniformDistributionProbability == null ? 0.0 : this.blockDistributionUniformDistributionProbability;
            return new BlockDistributionNearbyRandom(sizeMinimum, sizeMaximum, sizeRatio, uniformDistributionProbability);
        }
        if (linearDistributionEnabled) {
            int sizeMaximum = this.linearDistributionSizeMaximum == null ? Integer.MAX_VALUE : this.linearDistributionSizeMaximum;
            return new LinearDistributionNearbyRandom(sizeMaximum);
        }
        if (parabolicDistributionEnabled) {
            int sizeMaximum = this.parabolicDistributionSizeMaximum == null ? Integer.MAX_VALUE : this.parabolicDistributionSizeMaximum;
            return new ParabolicDistributionNearbyRandom(sizeMaximum);
        }
        if (betaDistributionEnabled) {
            double alpha = this.betaDistributionAlpha == null ? 1.0 : this.betaDistributionAlpha;
            double beta = this.betaDistributionBeta == null ? 5.0 : this.betaDistributionBeta;
            return new BetaDistributionNearbyRandom(alpha, beta);
        }
        return new BetaDistributionNearbyRandom(1.0, 5.0);
    }

    public void inherit(NearbySelectionConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        if (this.originEntitySelectorConfig == null) {
            this.originEntitySelectorConfig = inheritedConfig.getOriginEntitySelectorConfig();
        } else if (inheritedConfig.getOriginEntitySelectorConfig() != null) {
            this.originEntitySelectorConfig.inherit(inheritedConfig.getOriginEntitySelectorConfig());
        }
        this.nearbyDistanceMeterClass = ConfigUtils.inheritOverwritableProperty(this.nearbyDistanceMeterClass, inheritedConfig.getNearbyDistanceMeterClass());
        this.blockDistributionSizeMinimum = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeMinimum, inheritedConfig.getBlockDistributionSizeMinimum());
        this.blockDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeMaximum, inheritedConfig.getBlockDistributionSizeMaximum());
        this.blockDistributionSizeRatio = ConfigUtils.inheritOverwritableProperty(this.blockDistributionSizeRatio, inheritedConfig.getBlockDistributionSizeRatio());
        this.blockDistributionUniformDistributionProbability = ConfigUtils.inheritOverwritableProperty(this.blockDistributionUniformDistributionProbability, inheritedConfig.getBlockDistributionUniformDistributionProbability());
        this.linearDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.linearDistributionSizeMaximum, inheritedConfig.getLinearDistributionSizeMaximum());
        this.parabolicDistributionSizeMaximum = ConfigUtils.inheritOverwritableProperty(this.parabolicDistributionSizeMaximum, inheritedConfig.getParabolicDistributionSizeMaximum());
        this.betaDistributionAlpha = ConfigUtils.inheritOverwritableProperty(this.betaDistributionAlpha, inheritedConfig.getBetaDistributionAlpha());
        this.betaDistributionBeta = ConfigUtils.inheritOverwritableProperty(this.betaDistributionBeta, inheritedConfig.getBetaDistributionBeta());
    }
}

