/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.entity.nearby;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.optaplanner.core.impl.domain.entity.descriptor.EntityDescriptor;
import org.optaplanner.core.impl.heuristic.selector.common.iterator.SelectionIterator;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyDistanceMeter;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;
import org.optaplanner.core.impl.heuristic.selector.entity.AbstractEntitySelector;
import org.optaplanner.core.impl.heuristic.selector.entity.EntitySelector;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;

public class NearEntityNearbyEntitySelector
extends AbstractEntitySelector {
    protected final EntitySelector childEntitySelector;
    protected final EntitySelector originEntitySelector;
    protected final NearbyDistanceMeter nearbyDistanceMeter;
    protected final NearbyRandom nearbyRandom;
    protected final boolean randomSelection;
    protected final boolean discardNearbyIndexZero = true;
    protected Map<Object, Object[]> originToDestinationsMap = null;

    public NearEntityNearbyEntitySelector(EntitySelector childEntitySelector, EntitySelector originEntitySelector, NearbyDistanceMeter nearbyDistanceMeter, NearbyRandom nearbyRandom, boolean randomSelection) {
        this.childEntitySelector = childEntitySelector;
        this.originEntitySelector = originEntitySelector;
        this.nearbyDistanceMeter = nearbyDistanceMeter;
        this.nearbyRandom = nearbyRandom;
        this.randomSelection = randomSelection;
        if (!childEntitySelector.getEntityDescriptor().getEntityClass().isAssignableFrom(originEntitySelector.getEntityDescriptor().getEntityClass())) {
            throw new IllegalArgumentException("The entitySelector (" + this + ") has an entityClass (" + childEntitySelector.getEntityDescriptor().getEntityClass() + ") which is not a superclass of the originEntitySelector's entityClass (" + originEntitySelector.getEntityDescriptor().getEntityClass() + ").");
        }
        this.phaseLifecycleSupport.addEventListener(childEntitySelector);
        this.phaseLifecycleSupport.addEventListener(originEntitySelector);
    }

    @Override
    public void phaseStarted(AbstractPhaseScope phaseScope) {
        super.phaseStarted(phaseScope);
        long originSize = this.originEntitySelector.getSize();
        if (originSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The originEntitySelector (" + this.originEntitySelector + ") has an entitySize (" + originSize + ") which is higher than Integer.MAX_VALUE.");
        }
        this.originToDestinationsMap = new HashMap<Object, Object[]>((int)originSize);
        long childSize = this.childEntitySelector.getSize();
        if (childSize > Integer.MAX_VALUE) {
            throw new IllegalStateException("The childEntitySelector (" + this.childEntitySelector + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
        }
        Iterator<Object> originIt = this.originEntitySelector.endingIterator();
        while (originIt.hasNext()) {
            final Object origin = originIt.next();
            Object[] destinations = new Object[(int)childSize];
            int i = 0;
            Iterator<Object> childIt = this.childEntitySelector.endingIterator();
            while (childIt.hasNext()) {
                destinations[i] = childIt.next();
                ++i;
            }
            Arrays.sort(destinations, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b) {
                    double bDistance;
                    double aDistance = NearEntityNearbyEntitySelector.this.nearbyDistanceMeter.getNearbyDistance(origin, a);
                    if (aDistance < (bDistance = NearEntityNearbyEntitySelector.this.nearbyDistanceMeter.getNearbyDistance(origin, b))) {
                        return -1;
                    }
                    if (aDistance > bDistance) {
                        return 1;
                    }
                    return 0;
                }
            });
            this.originToDestinationsMap.put(origin, destinations);
        }
    }

    @Override
    public void phaseEnded(AbstractPhaseScope phaseScope) {
        super.phaseEnded(phaseScope);
        this.originToDestinationsMap = null;
    }

    @Override
    public EntityDescriptor getEntityDescriptor() {
        return this.childEntitySelector.getEntityDescriptor();
    }

    @Override
    public boolean isCountable() {
        return true;
    }

    @Override
    public boolean isNeverEnding() {
        return this.randomSelection;
    }

    @Override
    public long getSize() {
        return this.childEntitySelector.getSize() - 1L;
    }

    @Override
    public Iterator<Object> iterator() {
        if (!this.randomSelection) {
            return new OriginalNearbyEntityIterator(this.originEntitySelector.iterator(), this.childEntitySelector.getSize());
        }
        return new RandomNearbyEntityIterator(this.originEntitySelector.iterator(), this.childEntitySelector.getSize());
    }

    @Override
    public ListIterator<Object> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Object> endingIterator() {
        return this.childEntitySelector.endingIterator();
    }

    private class RandomNearbyEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> originEntityIterator;
        private final int nearbySize;

        public RandomNearbyEntityIterator(Iterator<Object> originEntityIterator, long childSize) {
            this.originEntityIterator = originEntityIterator;
            if (childSize > Integer.MAX_VALUE) {
                throw new IllegalStateException("The valueSelector (" + this + ") has an entitySize (" + childSize + ") which is higher than Integer.MAX_VALUE.");
            }
            this.nearbySize = (int)childSize - 1;
        }

        @Override
        public boolean hasNext() {
            return this.originEntityIterator.hasNext() && this.nearbySize > 0;
        }

        @Override
        public Object next() {
            Object origin = this.originEntityIterator.next();
            int nearbyIndex = NearEntityNearbyEntitySelector.this.nearbyRandom.nextInt(NearEntityNearbyEntitySelector.this.workingRandom, this.nearbySize);
            Object[] destinations = NearEntityNearbyEntitySelector.this.originToDestinationsMap.get(origin);
            return destinations[++nearbyIndex];
        }
    }

    private class OriginalNearbyEntityIterator
    extends SelectionIterator<Object> {
        private final Iterator<Object> originEntityIterator;
        private final long childSize;
        private int nextNearbyIndex;

        public OriginalNearbyEntityIterator(Iterator<Object> originEntityIterator, long childSize) {
            this.originEntityIterator = originEntityIterator;
            this.childSize = childSize;
            this.nextNearbyIndex = 1;
        }

        @Override
        public boolean hasNext() {
            return this.originEntityIterator.hasNext() && (long)this.nextNearbyIndex < this.childSize;
        }

        @Override
        public Object next() {
            Object origin = this.originEntityIterator.next();
            Object[] destinations = NearEntityNearbyEntitySelector.this.originToDestinationsMap.get(origin);
            Object next = destinations[this.nextNearbyIndex];
            ++this.nextNearbyIndex;
            return next;
        }
    }
}

