/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.solver.ProblemFactChange;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;

public class BasicPlumbingTermination
extends AbstractTermination {
    protected final boolean daemon;
    protected boolean terminatedEarly = false;
    protected BlockingQueue<ProblemFactChange> problemFactChangeQueue = new LinkedBlockingQueue<ProblemFactChange>();
    protected boolean problemFactChangesBeingProcessed = false;

    public BasicPlumbingTermination(boolean daemon) {
        this.daemon = daemon;
    }

    public synchronized void resetTerminateEarly() {
        this.terminatedEarly = false;
    }

    public synchronized boolean terminateEarly() {
        boolean terminationEarlySuccessful;
        boolean bl = terminationEarlySuccessful = !this.terminatedEarly;
        if (terminationEarlySuccessful) {
            this.logger.info("Terminating solver early.");
        }
        this.terminatedEarly = true;
        this.notifyAll();
        return terminationEarlySuccessful;
    }

    public synchronized boolean isTerminateEarly() {
        return this.terminatedEarly;
    }

    public synchronized boolean waitForRestartSolverDecision() {
        if (!this.daemon) {
            return !this.problemFactChangeQueue.isEmpty() && !this.terminatedEarly;
        }
        while (this.problemFactChangeQueue.isEmpty() && !this.terminatedEarly) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("Solver thread interrupted during wait.", e);
            }
        }
        return !this.terminatedEarly;
    }

    public synchronized boolean addProblemFactChange(ProblemFactChange problemFactChange) {
        boolean added = this.problemFactChangeQueue.add(problemFactChange);
        this.notifyAll();
        return added;
    }

    public synchronized BlockingQueue<ProblemFactChange> startProblemFactChangesProcessing() {
        this.problemFactChangesBeingProcessed = true;
        return this.problemFactChangeQueue;
    }

    public synchronized void endProblemFactChangesProcessing() {
        this.problemFactChangesBeingProcessed = false;
    }

    public boolean isEveryProblemFactChangeProcessed() {
        return this.problemFactChangeQueue.isEmpty() && !this.problemFactChangesBeingProcessed;
    }

    @Override
    public synchronized boolean isSolverTerminated(DefaultSolverScope solverScope) {
        return this.terminatedEarly || !this.problemFactChangeQueue.isEmpty();
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        throw new UnsupportedOperationException("BasicPlumbingTermination can only be used for solver termination.");
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        return -1.0;
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        throw new UnsupportedOperationException("BasicPlumbingTermination can only be used for solver termination.");
    }
}

