/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.optaplanner;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.optaplanner.OptaPlannerConfiguration;
import org.apache.camel.component.optaplanner.OptaPlannerEndpoint;
import org.apache.camel.impl.DefaultConsumer;
import org.optaplanner.core.api.solver.Solver;
import org.optaplanner.core.api.solver.event.BestSolutionChangedEvent;
import org.optaplanner.core.api.solver.event.SolverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OptaPlannerConsumer
extends DefaultConsumer {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(OptaPlannerConsumer.class);
    private final OptaPlannerEndpoint endpoint;
    private final OptaPlannerConfiguration configuration;
    private final SolverEventListener<Object> listener;

    public OptaPlannerConsumer(OptaPlannerEndpoint endpoint, Processor processor, OptaPlannerConfiguration configuration) {
        super((Endpoint)endpoint, processor);
        this.endpoint = endpoint;
        this.configuration = configuration;
        this.listener = new SolverEventListener<Object>(){

            @Override
            public void bestSolutionChanged(BestSolutionChangedEvent<Object> event) {
                if (event.isEveryProblemFactChangeProcessed() && event.getNewBestScore().isSolutionInitialized()) {
                    OptaPlannerConsumer.this.processEvent(event);
                }
            }
        };
    }

    public void processEvent(BestSolutionChangedEvent<Object> event) {
        Exchange exchange = this.getEndpoint().createExchange();
        exchange.getOut().setHeader("CamelOptaPlannerBestSolution", event.getNewBestSolution());
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            LOGGER.error("Error processing event ", (Throwable)e);
        }
    }

    protected void doStart() throws Exception {
        Solver<Object> solver = this.endpoint.getOrCreateSolver(this.configuration.getSolverId());
        solver.addEventListener(this.listener);
        super.doStart();
    }

    protected void doStop() throws Exception {
        Solver<Object> solver = this.endpoint.getOrCreateSolver(this.configuration.getSolverId());
        solver.removeEventListener(this.listener);
        super.doStop();
    }
}

