/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.lang.ref.WeakReference;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.compiler.compiler.io.memory.MemoryFileSystem;
import org.drools.compiler.kie.builder.impl.ClasspathKieProject;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieScanner;
import org.drools.compiler.kie.builder.impl.InternalKieServices;
import org.drools.compiler.kie.builder.impl.KieBuilderImpl;
import org.drools.compiler.kie.builder.impl.KieContainerImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemImpl;
import org.drools.compiler.kie.builder.impl.KieFileSystemScannerImpl;
import org.drools.compiler.kie.builder.impl.KieModuleKieProject;
import org.drools.compiler.kie.builder.impl.KieRepositoryImpl;
import org.drools.compiler.kie.builder.impl.event.KieServicesEventListerner;
import org.drools.compiler.kproject.ReleaseIdImpl;
import org.drools.compiler.kproject.models.KieModuleModelImpl;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.SessionConfiguration;
import org.drools.core.SessionConfigurationImpl;
import org.drools.core.audit.KnowledgeRuntimeLoggerProviderImpl;
import org.drools.core.command.impl.CommandFactoryServiceImpl;
import org.drools.core.concurrent.ExecutorProviderImpl;
import org.drools.core.impl.EnvironmentFactory;
import org.drools.core.io.impl.ResourceFactoryServiceImpl;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.kie.api.KieBaseConfiguration;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.KieRepository;
import org.kie.api.builder.KieScanner;
import org.kie.api.builder.KieScannerFactoryService;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.api.command.KieCommands;
import org.kie.api.concurrent.KieExecutors;
import org.kie.api.internal.utils.ServiceRegistry;
import org.kie.api.io.KieResources;
import org.kie.api.logger.KieLoggers;
import org.kie.api.marshalling.KieMarshallers;
import org.kie.api.persistence.jpa.KieStoreServices;
import org.kie.api.runtime.Environment;
import org.kie.api.runtime.KieContainer;
import org.kie.api.runtime.KieSessionConfiguration;

public class KieServicesImpl
implements InternalKieServices {
    private volatile KieContainer classpathKContainer;
    private volatile String classpathKContainerId;
    private volatile ClassLoader classpathClassLoader;
    private final Object lock = new Object();
    private WeakReference<KieServicesEventListerner> listener;
    private final ConcurrentMap<String, KieContainer> kContainers = new ConcurrentHashMap<String, KieContainer>();

    @Override
    public KieRepository getRepository() {
        return KieRepositoryImpl.INSTANCE;
    }

    @Override
    public KieContainer getKieClasspathContainer() {
        return this.getKieClasspathContainer(null, ProjectClassLoader.findParentClassLoader());
    }

    @Override
    public KieContainer getKieClasspathContainer(ClassLoader classLoader) {
        return this.getKieClasspathContainer(null, classLoader);
    }

    @Override
    public KieContainer getKieClasspathContainer(String containerId) {
        return this.getKieClasspathContainer(containerId, ProjectClassLoader.findParentClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KieContainer getKieClasspathContainer(String containerId, ClassLoader classLoader) {
        if (this.classpathKContainer == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.classpathKContainer == null) {
                    this.classpathClassLoader = classLoader;
                    this.classpathKContainerId = containerId == null ? UUID.randomUUID().toString() : containerId;
                    this.classpathKContainer = this.newKieClasspathContainer(this.classpathKContainerId, classLoader);
                } else if (classLoader != this.classpathClassLoader) {
                    throw new IllegalStateException("There's already another KieContainer created from a different ClassLoader");
                }
            }
        } else if (classLoader != this.classpathClassLoader) {
            throw new IllegalStateException("There's already another KieContainer created from a different ClassLoader");
        }
        if (containerId != null && !this.classpathKContainerId.equals(containerId)) {
            throw new IllegalStateException("The default global singleton KieClasspathContainer was already created with id " + this.classpathKContainerId);
        }
        return this.classpathKContainer;
    }

    @Override
    public KieContainer newKieClasspathContainer() {
        return this.newKieClasspathContainer(null, ProjectClassLoader.findParentClassLoader());
    }

    @Override
    public KieContainer newKieClasspathContainer(ClassLoader classLoader) {
        return this.newKieClasspathContainer(null, classLoader);
    }

    @Override
    public KieContainer newKieClasspathContainer(String containerId) {
        return this.newKieClasspathContainer(containerId, ProjectClassLoader.findParentClassLoader());
    }

    @Override
    public KieContainer newKieClasspathContainer(String containerId, ClassLoader classLoader) {
        return this.newKieClasspathContainer(containerId, classLoader, null);
    }

    @Override
    public KieContainer newKieClasspathContainer(String containerId, ClassLoader classLoader, ReleaseId releaseId) {
        if (containerId == null) {
            KieContainerImpl newContainer = new KieContainerImpl(UUID.randomUUID().toString(), new ClasspathKieProject(classLoader, this.listener, releaseId), null);
            return newContainer;
        }
        if (this.kContainers.get(containerId) == null) {
            KieContainerImpl newContainer = new KieContainerImpl(containerId, new ClasspathKieProject(classLoader, this.listener, releaseId), null, releaseId);
            KieContainer check = this.kContainers.putIfAbsent(containerId, newContainer);
            if (check == null) {
                return newContainer;
            }
            newContainer.dispose();
            throw new IllegalStateException("There's already another KieContainer created with the id " + containerId);
        }
        throw new IllegalStateException("There's already another KieContainer created with the id " + containerId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullKieClasspathContainer() {
        Object object = this.lock;
        synchronized (object) {
            this.classpathKContainer = null;
            this.classpathKContainerId = null;
            this.classpathClassLoader = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nullAllContainerIds() {
        Object object = this.lock;
        synchronized (object) {
            this.kContainers.clear();
        }
    }

    @Override
    public void clearRefToContainerId(String containerId, KieContainer containerRef) {
        this.kContainers.remove(containerId, containerRef);
    }

    @Override
    public KieContainer newKieContainer(ReleaseId releaseId) {
        return this.newKieContainer(null, releaseId, null);
    }

    @Override
    public KieContainer newKieContainer(String containerId, ReleaseId releaseId) {
        return this.newKieContainer(containerId, releaseId, null);
    }

    @Override
    public KieContainer newKieContainer(ReleaseId releaseId, ClassLoader classLoader) {
        return this.newKieContainer(null, releaseId, classLoader);
    }

    @Override
    public KieContainer newKieContainer(String containerId, ReleaseId releaseId, ClassLoader classLoader) {
        KieModuleKieProject kProject;
        InternalKieModule kieModule = (InternalKieModule)this.getRepository().getKieModule(releaseId);
        if (kieModule == null) {
            throw new RuntimeException("Cannot find KieModule: " + releaseId);
        }
        if (classLoader == null) {
            classLoader = kieModule.getModuleClassLoader();
        }
        if (classLoader != (kProject = new KieModuleKieProject(kieModule, classLoader)).getClassLoader()) {
            kProject.init();
        }
        if (containerId == null) {
            KieContainerImpl newContainer = new KieContainerImpl(UUID.randomUUID().toString(), kProject, this.getRepository(), releaseId);
            return newContainer;
        }
        if (this.kContainers.get(containerId) == null) {
            KieContainerImpl newContainer = new KieContainerImpl(containerId, kProject, this.getRepository(), releaseId);
            KieContainer check = this.kContainers.putIfAbsent(containerId, newContainer);
            if (check == null) {
                return newContainer;
            }
            newContainer.dispose();
            throw new IllegalStateException("There's already another KieContainer created with the id " + containerId);
        }
        throw new IllegalStateException("There's already another KieContainer created with the id " + containerId);
    }

    @Override
    public KieBuilder newKieBuilder(File file) {
        return file.isDirectory() ? new KieBuilderImpl(file) : this.newKieBuilder(new KieFileSystemImpl(MemoryFileSystem.readFromJar(file)));
    }

    @Override
    public KieBuilder newKieBuilder(KieFileSystem kieFileSystem) {
        return new KieBuilderImpl(kieFileSystem);
    }

    @Override
    public KieBuilder newKieBuilder(KieFileSystem kieFileSystem, ClassLoader classLoader) {
        return new KieBuilderImpl(kieFileSystem, classLoader);
    }

    @Override
    public KieScanner newKieScanner(KieContainer kieContainer) {
        KieScannerFactoryService scannerFactoryService = ServiceRegistry.getService(KieScannerFactoryService.class);
        if (scannerFactoryService == null) {
            throw new RuntimeException("Cannot instance a maven based KieScanner, is kie-ci on the classpath?");
        }
        InternalKieScanner scanner = (InternalKieScanner)scannerFactoryService.newKieScanner();
        scanner.setKieContainer(kieContainer);
        return scanner;
    }

    @Override
    public KieScanner newKieScanner(KieContainer kieContainer, String repositoryFolder) {
        return new KieFileSystemScannerImpl(kieContainer, repositoryFolder);
    }

    @Override
    public KieResources getResources() {
        return new ResourceFactoryServiceImpl();
    }

    @Override
    public KieCommands getCommands() {
        return new CommandFactoryServiceImpl();
    }

    @Override
    public KieMarshallers getMarshallers() {
        KieMarshallers kieMarshallers = ServiceRegistry.getService(KieMarshallers.class);
        if (kieMarshallers == null) {
            throw new RuntimeException("Marshaller not available, please add the module org.drools:drools-serialization-protobuf to your classpath.");
        }
        return kieMarshallers;
    }

    @Override
    public KieLoggers getLoggers() {
        return new KnowledgeRuntimeLoggerProviderImpl();
    }

    public KieExecutors getExecutors() {
        return new ExecutorProviderImpl();
    }

    @Override
    public KieStoreServices getStoreServices() {
        return ServiceRegistry.getService(KieStoreServices.class);
    }

    @Override
    public ReleaseId newReleaseId(String groupId, String artifactId, String version) {
        return new ReleaseIdImpl(groupId, artifactId, version);
    }

    @Override
    public KieModuleModel newKieModuleModel() {
        return new KieModuleModelImpl();
    }

    @Override
    public KieFileSystem newKieFileSystem() {
        return new KieFileSystemImpl();
    }

    @Override
    public KieBaseConfiguration newKieBaseConfiguration() {
        return new RuleBaseConfiguration();
    }

    @Override
    public KieBaseConfiguration newKieBaseConfiguration(Properties properties) {
        return new RuleBaseConfiguration(properties, null);
    }

    @Override
    public KieBaseConfiguration newKieBaseConfiguration(Properties properties, ClassLoader classLoader) {
        return new RuleBaseConfiguration(properties, classLoader);
    }

    @Override
    public KieSessionConfiguration newKieSessionConfiguration() {
        return SessionConfiguration.newInstance();
    }

    @Override
    public KieSessionConfiguration newKieSessionConfiguration(Properties properties) {
        return new SessionConfigurationImpl(properties);
    }

    @Override
    public KieSessionConfiguration newKieSessionConfiguration(Properties properties, ClassLoader classLoader) {
        return new SessionConfigurationImpl(properties, classLoader);
    }

    @Override
    public Environment newEnvironment() {
        return EnvironmentFactory.newEnvironment();
    }

    @Override
    public void registerListener(KieServicesEventListerner listener) {
        this.listener = new WeakReference<KieServicesEventListerner>(listener);
    }
}

