/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.kie.builder.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.drools.compiler.kie.builder.impl.AbstractKieModule;
import org.drools.compiler.kie.builder.impl.InternalKieModule;
import org.drools.core.io.internal.InternalResource;
import org.drools.core.util.IoUtils;
import org.kie.api.builder.ReleaseId;
import org.kie.api.builder.model.KieModuleModel;
import org.kie.internal.io.ResourceFactory;

public class ZipKieModule
extends AbstractKieModule
implements InternalKieModule,
Serializable {
    private File file;
    private Map<String, byte[]> zipEntries;
    private List<String> fileNames;

    public ZipKieModule() {
    }

    public ZipKieModule(ReleaseId releaseId, KieModuleModel kieProject, File file) {
        super(releaseId, kieProject);
        this.file = file;
        this.indexZipFile(file);
    }

    @Override
    public InternalResource getResource(String fileName) {
        byte[] bytes = this.getBytes(fileName);
        if (bytes != null) {
            return (InternalResource)ResourceFactory.newByteArrayResource(bytes).setSourcePath(fileName);
        }
        return null;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public boolean isAvailable(String name) {
        return this.zipEntries.containsKey(name);
    }

    @Override
    public byte[] getBytes(String name) {
        return this.zipEntries.get(name);
    }

    @Override
    public Collection<String> getFileNames() {
        return this.fileNames;
    }

    @Override
    public byte[] getBytes() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getCreationTimestamp() {
        return this.file.lastModified();
    }

    public String toString() {
        return "ZipKieModule[releaseId=" + this.getReleaseId() + ",file=" + this.file + "]";
    }

    private void indexZipFile(File jarFile) {
        Map<String, List<String>> folders;
        this.zipEntries = new HashMap<String, byte[]>();
        this.fileNames = new ArrayList<String>();
        try {
            folders = this.processZipEntries(jarFile);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to get all ZipFile entries: " + jarFile, e);
        }
        for (Map.Entry<String, List<String>> folder : folders.entrySet()) {
            StringBuilder sb = new StringBuilder();
            for (String child : folder.getValue()) {
                sb.append(child).append("\n");
            }
            this.zipEntries.put(folder.getKey(), sb.toString().getBytes(StandardCharsets.UTF_8));
        }
    }

    protected Map<String, List<String>> processZipEntries(File jarFile) throws IOException {
        if (jarFile.exists()) {
            return this.processZipFile(jarFile);
        }
        String urlPath = jarFile.getAbsolutePath();
        int urlSeparatorPos = urlPath.indexOf(33);
        if (urlSeparatorPos > 0) {
            return this.processZipUrl(urlPath, urlSeparatorPos);
        }
        throw new FileNotFoundException(urlPath);
    }

    /*
     * Exception decompiling
     */
    private Map<String, List<String>> processZipFile(File jarFile) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, List<String>> processZipUrl(String urlPath, int urlSeparatorPos) throws IOException {
        String folderInUrl = urlPath.substring(urlSeparatorPos + 1).replace("\\", "/");
        InputStream in = this.getClass().getResourceAsStream(folderInUrl);
        if (in == null) {
            return this.processFolderInZipFile(urlPath, urlSeparatorPos);
        }
        try (ZipInputStream zipIn = new ZipInputStream(in);){
            ZipEntry entry = zipIn.getNextEntry();
            Map<String, List<String>> map = entry == null ? this.processFolderInZipFile(urlPath, urlSeparatorPos) : this.processZipEntries(zipIn, entry, null);
            return map;
        }
    }

    /*
     * Exception decompiling
     */
    private Map<String, List<String>> processFolderInZipFile(String urlPath, int urlSeparatorPos) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private Map<String, List<String>> processZipEntries(ZipInputStream zipIn, ZipEntry entry, String rootFolder) throws IOException {
        HashMap<String, List<String>> folders = new HashMap<String, List<String>>();
        while (entry != null) {
            this.processEntry(entry, folders, zipIn, rootFolder);
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        return folders;
    }

    private void processEntry(ZipEntry entry, Map<String, List<String>> folders, InputStream stream, String rootFolder) throws IOException {
        int lastSlashPos;
        String entryName = entry.getName();
        if (entryName.endsWith(".dex")) {
            return;
        }
        if (rootFolder != null) {
            if (entryName.startsWith(rootFolder)) {
                entryName = entryName.substring(rootFolder.length() + 1);
            } else {
                return;
            }
        }
        if (entry.isDirectory()) {
            if (entryName.endsWith("/")) {
                entryName = entryName.substring(0, entryName.length() - 1);
            }
        } else {
            byte[] bytes = IoUtils.readBytesFromInputStream(stream, false);
            this.zipEntries.put(entryName, bytes);
            this.fileNames.add(entryName);
        }
        String folderName = (lastSlashPos = entryName.lastIndexOf(47)) < 0 ? "" : entryName.substring(0, lastSlashPos);
        List folder = folders.computeIfAbsent(folderName, k -> new ArrayList());
        folder.add(lastSlashPos < 0 ? entryName : entryName.substring(lastSlashPos + 1));
    }
}

