/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.drools.compiler.lang.descr.AnnotatedBaseDescr;
import org.drools.core.factmodel.PropertyMap;

public class AnnotationDescr
extends AnnotatedBaseDescr
implements PropertyMap {
    public static final String VALUE = "value";
    private static final long serialVersionUID = 520L;
    private String name;
    private String fullyQualifiedName;
    private Map<String, Object> values;
    private boolean duplicated = false;
    private boolean strict = false;

    public static String unquote(String s2) {
        if (s2.startsWith("\"") && s2.endsWith("\"") || s2.startsWith("'") && s2.endsWith("'")) {
            return s2.substring(1, s2.length() - 1);
        }
        return s2;
    }

    public AnnotationDescr() {
    }

    public AnnotationDescr(String name) {
        this.name = name;
        this.values = new HashMap<String, Object>();
    }

    public AnnotationDescr(String name, String value) {
        this(name);
        this.values.put(VALUE, value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.name = (String)in.readObject();
        this.values = (Map)in.readObject();
        this.fullyQualifiedName = (String)in.readObject();
        this.duplicated = in.readBoolean();
        this.strict = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.name);
        out.writeObject(this.values);
        out.writeObject(this.fullyQualifiedName);
        out.writeBoolean(this.duplicated);
        out.writeBoolean(this.strict);
    }

    public String getName() {
        return this.name;
    }

    public String getFullyQualifiedName() {
        return this.fullyQualifiedName;
    }

    public void setFullyQualifiedName(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    public boolean hasValue() {
        return !this.values.isEmpty();
    }

    public void setValue(Object value) {
        this.values.put(VALUE, value);
    }

    public void setKeyValue(String key, Object value) {
        this.values.put(key, value);
    }

    public Object getValue(String key) {
        return this.values.get(key);
    }

    @Override
    public Map<String, Object> getValues() {
        return this.values;
    }

    public Object getValue() {
        Map<String, Object> single = this.getSingleValue();
        return single != null ? single : this.values;
    }

    public Object getValueStripped() {
        Object single = this.getSingleValueStripped();
        if (single != null) {
            return single;
        }
        HashMap<String, String> sMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            sMap.put(entry.getKey(), AnnotationDescr.unquote(entry.getValue().toString()));
        }
        return sMap;
    }

    public Map<String, Object> getValueMap() {
        return this.values;
    }

    public Object getSingleValue() {
        if (this.values.size() == 1 && this.values.containsKey(VALUE)) {
            return this.values.get(VALUE);
        }
        return null;
    }

    public Object getSingleValueStripped() {
        if (this.values.size() == 1 && this.values.containsKey(VALUE)) {
            return AnnotationDescr.unquote(this.values.get(VALUE).toString());
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnnotationDescr other = (AnnotationDescr)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String getSingleValueAsString() {
        return this.getValueAsString(VALUE);
    }

    public String getValueAsString(String key) {
        Object x = this.getValue(key);
        if (x == null) {
            return null;
        }
        if (x.getClass().isArray()) {
            return Arrays.toString((Object[])x);
        }
        return x.toString();
    }

    public String getValuesAsString() {
        switch (this.values.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return this.getSingleValue().toString();
            }
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String key : this.values.keySet()) {
            if (!first) {
                sb.append(",");
            }
            sb.append(key).append("=").append(this.values.get(key));
            if (!first) continue;
            first = false;
        }
        return sb.toString();
    }

    public boolean isDuplicated() {
        return this.duplicated;
    }

    public void setDuplicated() {
        this.duplicated = true;
    }

    public boolean isStrict() {
        return this.strict;
    }

    public void setStrict(boolean strict) {
        this.strict = strict;
    }
}

