/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.descr;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drools.compiler.lang.descr.RestrictionDescr;
import org.drools.core.util.StringUtils;

public class ConnectiveDescr
extends RestrictionDescr {
    private static final long serialVersionUID = 510L;
    public static final RestrictionConnectiveType AND = RestrictionConnectiveType.AND;
    public static final RestrictionConnectiveType OR = RestrictionConnectiveType.OR;
    private RestrictionConnectiveType connective;
    private List<Object> children;
    private String prefix;
    private boolean paren;

    public ConnectiveDescr() {
    }

    public ConnectiveDescr(RestrictionConnectiveType connective) {
        this.connective = connective;
        this.children = Collections.emptyList();
        this.paren = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.connective = (RestrictionConnectiveType)((Object)in.readObject());
        this.children = (List)in.readObject();
        this.prefix = (String)in.readObject();
        this.paren = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject((Object)this.connective);
        out.writeObject(this.children);
        out.writeObject(this.prefix);
        out.writeBoolean(this.paren);
    }

    public RestrictionConnectiveType getConnective() {
        return this.connective;
    }

    public boolean isParen() {
        return this.paren;
    }

    public void setParen(boolean paren) {
        this.paren = paren;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void add(ConnectiveDescr restriction) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList<Object>(2);
        }
        this.children.add(restriction);
    }

    public void add(String restriction) {
        if (this.children == Collections.EMPTY_LIST) {
            this.children = new ArrayList<Object>(2);
        }
        this.children.add(restriction);
    }

    public List<Object> getRestrictions() {
        return this.children;
    }

    public void buildExpression(StringBuilder sb) {
        if (!StringUtils.isEmpty(this.prefix)) {
            sb.append(this.prefix);
            sb.append(" ");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.isParen() && this.children.get(i) instanceof ConnectiveDescr) {
                sb.append("(");
                ((ConnectiveDescr)this.children.get(i)).buildExpression(sb);
                sb.append(")");
            } else {
                sb.append(this.children.get(i));
            }
            if (i >= this.children.size() - 1) continue;
            sb.append(" ");
            sb.append((Object)this.connective);
            sb.append(" ");
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        this.buildExpression(buf);
        return buf.toString();
    }

    public static enum RestrictionConnectiveType {
        AND{

            public String toString() {
                return "&&";
            }
        }
        ,
        OR{

            public String toString() {
                return "||";
            }
        };

    }
}

