/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.lang.dsl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.drools.compiler.lang.Expander;
import org.drools.compiler.lang.ExpanderException;
import org.drools.compiler.lang.dsl.AntlrDSLMappingEntry;
import org.drools.compiler.lang.dsl.DSLMapping;
import org.drools.compiler.lang.dsl.DSLMappingEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultExpander
implements Expander {
    protected static final transient Logger logger = LoggerFactory.getLogger(DefaultExpander.class);
    private static final String ruleOrQuery = "^(?:                         \\p{Blank}*(rule\\b.+?^\\s*when\\b)(.*?)                       ^(\\s*then)                 (.*?)                       (^\\s*end.*?$)              |\\s*(query\\s+             (?:\"[^\"]+\"|'[^']+'|\\S+) (?:\\s*\\([^)]+\\))?)       (.*?)                       (^\\s*end.*?$)              )";
    private static final Pattern finder = Pattern.compile("^(?:                         \\p{Blank}*(rule\\b.+?^\\s*when\\b)(.*?)                       ^(\\s*then)                 (.*?)                       (^\\s*end.*?$)              |\\s*(query\\s+             (?:\"[^\"]+\"|'[^']+'|\\S+) (?:\\s*\\([^)]+\\))?)       (.*?)                       (^\\s*end.*?$)              )", 44);
    private static final Pattern comments = Pattern.compile("/\\*.*?\\*/", 32);
    private static final Pattern modifyFinder = Pattern.compile("\\{(.*?)\\}");
    private static final String funcPatStr = "(?:!(uc|lc|ucfirst|num|.*))?";
    private static final Pattern varRefPat = Pattern.compile("\\{([\\p{L}\\d]+)(?:!(uc|lc|ucfirst|num|.*))?\\}");
    private static final Pattern intPat = Pattern.compile("^(-?\\d+).*$");
    private final List<DSLMappingEntry> keywords = new ArrayList<DSLMappingEntry>();
    private final List<DSLMappingEntry> condition = new ArrayList<DSLMappingEntry>();
    private final List<DSLMappingEntry> consequence = new ArrayList<DSLMappingEntry>();
    private final List<DSLMappingEntry> cleanup = new ArrayList<DSLMappingEntry>();
    private Map<String, Integer> useKeyword;
    private Map<String, Integer> useWhen;
    private Map<String, Integer> useThen;
    private List<Map<String, String>> substitutions;
    private List<ExpanderException> errors = Collections.emptyList();
    private boolean showResult = false;
    private boolean showSteps = false;
    private boolean showWhen = false;
    private boolean showThen = false;
    private boolean showKeyword = false;
    private boolean showUsage = false;
    private static final String nl = System.getProperty("line.separator");
    private Pattern letterPat = Pattern.compile("\\p{L}");

    public DefaultExpander() {
        this.cleanup.add(new AntlrDSLMappingEntry(DSLMappingEntry.KEYWORD, DSLMappingEntry.EMPTY_METADATA, "expander {name}", "", "expander (.*?)", ""));
    }

    @Override
    public void addDSLMapping(DSLMapping mapping) {
        for (DSLMappingEntry entry : mapping.getEntries()) {
            if (DSLMappingEntry.KEYWORD.equals((Object)entry.getSection())) {
                this.keywords.add(entry);
                continue;
            }
            if (DSLMappingEntry.CONDITION.equals((Object)entry.getSection())) {
                this.condition.add(entry);
                continue;
            }
            if (DSLMappingEntry.CONSEQUENCE.equals((Object)entry.getSection())) {
                this.consequence.add(entry);
                continue;
            }
            this.condition.add(entry);
            this.consequence.add(entry);
        }
        if (mapping.getOption("result")) {
            this.showResult = true;
        }
        if (mapping.getOption("steps")) {
            this.showSteps = true;
        }
        if (mapping.getOption("keyword")) {
            this.showKeyword = true;
        }
        if (mapping.getOption("when")) {
            this.showWhen = true;
        }
        if (mapping.getOption("then")) {
            this.showThen = true;
        }
        if (mapping.getOption("usage")) {
            this.showUsage = true;
        }
    }

    @Override
    public String expand(Reader drlReader) throws IOException {
        return this.expand(this.loadDrlFile(drlReader));
    }

    private void displayUsage(String what, Map<String, Integer> use) {
        logger.info("=== Usage of " + what + " ===");
        Formatter fmt = new Formatter(System.out);
        for (Map.Entry<String, Integer> entry : use.entrySet()) {
            fmt.format("%4d %s%n", entry.getValue(), entry.getKey());
        }
    }

    @Override
    public String expand(String drl) {
        if (this.showUsage) {
            this.useKeyword = new HashMap<String, Integer>();
            this.useWhen = new HashMap<String, Integer>();
            this.useThen = new HashMap<String, Integer>();
        }
        drl = this.removeComments(drl);
        drl = this.expandKeywords(drl);
        drl = this.cleanupExpressions(drl);
        StringBuffer buf = this.expandConstructions(drl);
        if (this.showUsage) {
            this.displayUsage("keyword", this.useKeyword);
            this.displayUsage("when", this.useWhen);
            this.displayUsage("then", this.useThen);
        }
        if (this.showResult) {
            StringBuffer show = new StringBuffer();
            try (Formatter fmt = new Formatter(show);){
                int nlPos;
                int offset = 0;
                int iLine = 1;
                while ((nlPos = buf.indexOf(nl, offset)) >= 0) {
                    fmt.format("%4d  %s%n", iLine++, buf.substring(offset, nlPos));
                    offset = nlPos + 1;
                }
                logger.info("=== DRL xpanded from DSLR ===");
                logger.info(show.toString());
                logger.info("=============================");
            }
        }
        return buf.toString();
    }

    private static int countNewlines(String drl, int start, int end) {
        int count = 0;
        int pos = start;
        while ((pos = drl.indexOf(nl, pos)) >= 0 && pos < end) {
            pos += nl.length();
            ++count;
        }
        return count;
    }

    private StringBuffer expandConstructions(String drl) {
        if (this.showKeyword) {
            for (DSLMappingEntry entry : this.keywords) {
                logger.info("keyword: " + entry.getMappingKey());
                logger.info("         " + entry.getKeyPattern());
            }
        }
        if (this.showWhen) {
            for (DSLMappingEntry entry : this.condition) {
                logger.info("when: " + entry.getMappingKey());
                logger.info("      " + entry.getKeyPattern());
            }
        }
        if (this.showThen) {
            for (DSLMappingEntry entry : this.consequence) {
                logger.info("then: " + entry.getMappingKey());
                logger.info("      " + entry.getKeyPattern());
            }
        }
        Matcher m4 = finder.matcher(drl);
        StringBuffer buf = new StringBuffer();
        int drlPos = 0;
        int linecount = 0;
        while (m4.find()) {
            String lhsFragment;
            StringBuilder expanded = new StringBuilder();
            int newPos = m4.start();
            linecount += DefaultExpander.countNewlines(drl, drlPos, newPos);
            drlPos = newPos;
            String constr = m4.group().trim();
            if (constr.startsWith("rule")) {
                String headerFragment = m4.group(1);
                expanded.append(headerFragment);
                lhsFragment = m4.group(2);
                expanded.append(this.expandLHS(lhsFragment, linecount + DefaultExpander.countNewlines(drl, drlPos, m4.start(2)) + 1));
                String thenFragment = m4.group(3);
                expanded.append(thenFragment);
                String rhsFragment = this.expandRHS(m4.group(4), linecount + DefaultExpander.countNewlines(drl, drlPos, m4.start(4)) + 1);
                expanded.append(rhsFragment);
                expanded.append(m4.group(5));
            } else if (constr.startsWith("query")) {
                String fragment = m4.group(6);
                expanded.append(fragment);
                lhsFragment = this.expandLHS(m4.group(7), linecount + DefaultExpander.countNewlines(drl, drlPos, m4.start(7)) + 1);
                expanded.append(lhsFragment);
                expanded.append(m4.group(8));
            } else {
                this.addError(new ExpanderException("Unable to expand statement: " + constr, 0));
            }
            m4.appendReplacement(buf, Matcher.quoteReplacement(expanded.toString()));
        }
        m4.appendTail(buf);
        return buf;
    }

    private String cleanupExpressions(String drl) {
        for (DSLMappingEntry entry : this.cleanup) {
            drl = entry.getKeyPattern().matcher(drl).replaceAll(entry.getValuePattern());
        }
        return drl;
    }

    private String removeComments(String drl) {
        return comments.matcher(drl).replaceAll("");
    }

    private String expandKeywords(String drl) {
        this.substitutions = new ArrayList<Map<String, String>>();
        drl = this.substitute(drl, this.keywords, 0, this.useKeyword, false);
        this.substitutions = null;
        return drl;
    }

    private String applyFunc(String theFunc, String theValue) {
        block7: {
            block10: {
                block9: {
                    block8: {
                        if (theFunc == null) break block7;
                        if (!"uc".equals(theFunc)) break block8;
                        theValue = theValue.toUpperCase();
                        break block7;
                    }
                    if (!"lc".equals(theFunc)) break block9;
                    theValue = theValue.toLowerCase();
                    break block7;
                }
                if (!"ucfirst".equals(theFunc)) break block10;
                Matcher letterMat = this.letterPat.matcher(theValue);
                if (!letterMat.find()) break block7;
                int pos = letterMat.start();
                theValue = theValue.substring(0, pos) + theValue.substring(pos, pos + 1).toUpperCase() + theValue.substring(pos + 1).toLowerCase();
                break block7;
            }
            if (theFunc.startsWith("num")) {
                String numStr = theValue.replaceAll("[^-\\d]+", "");
                try {
                    long numLong = Long.parseLong(numStr);
                    if (theValue.matches("^.*[.,]\\d\\d(?:\\D.*|$)")) {
                        numStr = Long.toString(numLong);
                        theValue = numStr.substring(0, numStr.length() - 2) + '.' + numStr.substring(numStr.length() - 2);
                        break block7;
                    }
                    theValue = Long.toString(numLong);
                }
                catch (NumberFormatException numLong) {}
            } else {
                StringTokenizer strTok = new StringTokenizer(theFunc, "?/", true);
                boolean compare = true;
                int toks = strTok.countTokens();
                while (toks >= 4) {
                    String key = strTok.nextToken();
                    String qmk = strTok.nextToken();
                    String val = strTok.nextToken();
                    String sep = strTok.nextToken();
                    if (key.equals(theValue)) {
                        theValue = val;
                        break;
                    }
                    if ((toks -= 4) >= 4) continue;
                    theValue = strTok.nextToken();
                    break;
                }
            }
        }
        return theValue;
    }

    private String substitute(String exp, List<DSLMappingEntry> entries, int line, Map<String, Integer> use, boolean showSingleSteps) {
        if (entries.size() == 0) {
            if (line > 0) {
                this.addError(new ExpanderException("No mapping entries for expanding: " + exp, line));
            }
            return exp;
        }
        if (showSingleSteps) {
            logger.info("to expand: |" + exp + "|");
        }
        HashMap<String, String> key2value = new HashMap<String, String>();
        for (DSLMappingEntry entry : entries) {
            Integer count;
            Map<String, Integer> vars = entry.getVariables();
            String mappingKey = entry.getMappingKey();
            String vp = entry.getValuePattern();
            Pattern kp = entry.getKeyPattern();
            Matcher m4 = kp.matcher(exp);
            int startPos = 0;
            if (this.showUsage && (count = use.get(mappingKey)) == null) {
                use.put(mappingKey, 0);
            }
            while (startPos < exp.length() && m4.find(startPos)) {
                boolean match = true;
                if (showSingleSteps) {
                    logger.info("  matches: " + kp.toString());
                }
                if (this.showUsage) {
                    use.put(mappingKey, use.get(mappingKey) + 1);
                }
                String target = m4.group(0);
                if (!vars.keySet().isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    String del = "\\{(";
                    for (String key : vars.keySet()) {
                        sb.append(del).append(Pattern.quote(key));
                        del = "|";
                    }
                    sb.append(")").append(funcPatStr).append("\\}");
                    Pattern allkeyPat = Pattern.compile(sb.toString());
                    vp = entry.getValuePattern();
                    Matcher allkeyMat = allkeyPat.matcher(vp);
                    while (allkeyMat.find()) {
                        String theKey = allkeyMat.group(1);
                        String theFunc = allkeyMat.group(2);
                        String foundValue = m4.group(vars.get(theKey));
                        String theValue = this.applyFunc(theFunc, foundValue);
                        String newVp = vp.substring(0, allkeyMat.start()) + theValue + vp.substring(allkeyMat.end());
                        allkeyMat.reset(newVp);
                        key2value.put(theKey, foundValue);
                        if (newVp.equals(vp)) break;
                        vp = newVp;
                    }
                }
                Matcher varRefMat = varRefPat.matcher(vp);
                block4: while (varRefMat.find()) {
                    String theKey = varRefMat.group(1);
                    String theFunc = varRefMat.group(2);
                    for (int ientry = this.substitutions.size() - 1; ientry >= 0; --ientry) {
                        String foundValue = this.substitutions.get(ientry).get(theKey);
                        if (foundValue == null) continue;
                        String theValue = this.applyFunc(theFunc, foundValue);
                        vp = vp.substring(0, varRefMat.start()) + theValue + vp.substring(varRefMat.end());
                        varRefMat.reset(vp);
                        continue block4;
                    }
                }
                if (key2value.size() > 0) {
                    this.substitutions.add(key2value);
                }
                exp = exp.substring(0, m4.start()) + vp + exp.substring(m4.end());
                if (match && showSingleSteps) {
                    logger.info("   result: |" + exp + "|");
                }
                startPos = m4.start() + vp.length();
                m4.reset(exp);
            }
        }
        return exp;
    }

    private String expandLHS(String lhs, int lineOffset) {
        int i;
        this.substitutions = new ArrayList<Map<String, String>>();
        StringBuilder buf = new StringBuilder();
        String[] lines = lhs.split(lhs.indexOf("\r\n") >= 0 ? "\r\n" : "\n", -1);
        String[] expanded = new String[lines.length];
        int lastExpanded = -1;
        int lastPattern = -1;
        for (i = 0; i < lines.length - 1; ++i) {
            String trimmed = lines[i].trim();
            expanded[++lastExpanded] = lines[i];
            if (trimmed.length() == 0 || trimmed.startsWith("#") || trimmed.startsWith("//")) continue;
            if (trimmed.startsWith(">")) {
                expanded[lastExpanded] = lines[i].replaceFirst(">", " ");
                lastPattern = lastExpanded;
                continue;
            }
            expanded[lastExpanded] = this.substitute(expanded[lastExpanded], this.condition, i + lineOffset, this.useWhen, this.showSteps);
            if (lines[i].equals(expanded[lastExpanded])) {
                this.addError(new ExpanderException("Unable to expand: " + lines[i].replaceAll("[\n\r]", "").trim(), i + lineOffset));
            }
            if (trimmed.startsWith("-") && !lines[i].equals(expanded[lastExpanded])) {
                if (lastPattern >= 0) {
                    ConstraintInformation c = ConstraintInformation.findConstraintInformationInPattern(expanded[lastPattern]);
                    if (c.start > -1) {
                        expanded[lastPattern] = expanded[lastPattern].substring(0, c.start) + c.constraints + (c.constraints.trim().length() == 0 ? "" : ", ") + expanded[lastExpanded].trim() + expanded[lastPattern].substring(c.end);
                    } else {
                        this.addError(new ExpanderException("No pattern was found to add the constraint to: " + lines[i].trim(), i + lineOffset));
                    }
                }
                --lastExpanded;
                continue;
            }
            lastPattern = lastExpanded;
        }
        for (i = 0; i <= lastExpanded; ++i) {
            buf.append(expanded[i]);
            buf.append(nl);
        }
        return buf.toString();
    }

    private String expandRHS(String lhs, int lineOffset) {
        int i;
        StringBuilder buf = new StringBuilder();
        String[] lines = lhs.split(lhs.indexOf("\r\n") >= 0 ? "\r\n" : "\n", -1);
        String[] expanded = new String[lines.length];
        int lastExpanded = -1;
        int lastPattern = -1;
        for (i = 0; i < lines.length - 1; ++i) {
            String trimmed = lines[i].trim();
            expanded[++lastExpanded] = lines[i];
            if (trimmed.length() == 0 || trimmed.startsWith("#") || trimmed.startsWith("//")) {
                buf.append(lines[i]);
                continue;
            }
            if (trimmed.startsWith(">")) {
                expanded[lastExpanded] = lines[i].replaceFirst(">", " ");
                continue;
            }
            expanded[lastExpanded] = this.substitute(expanded[lastExpanded], this.consequence, i + lineOffset, this.useThen, this.showSteps);
            if (lines[i].equals(expanded[lastExpanded])) {
                this.addError(new ExpanderException("Unable to expand: " + lines[i], i + lineOffset));
            }
            if (trimmed.startsWith("-") && !lines[i].equals(expanded[lastExpanded])) {
                int lastMatchStart = -1;
                int lastMatchEnd = -1;
                String modifiers = "";
                if (lastPattern >= 0) {
                    Matcher m22 = modifyFinder.matcher(expanded[lastPattern]);
                    while (m22.find()) {
                        lastMatchStart = m22.start();
                        lastMatchEnd = m22.end();
                        modifiers = m22.group(1).trim();
                    }
                }
                if (lastMatchStart > -1) {
                    expanded[lastPattern] = expanded[lastPattern].substring(0, lastMatchStart) + "{ " + modifiers + (modifiers.length() == 0 ? "" : ", ") + expanded[lastExpanded].trim() + " }" + expanded[lastPattern].substring(lastMatchEnd);
                } else {
                    this.addError(new ExpanderException("No modify was found to add the modifier to: " + lines[i].trim(), i + lineOffset));
                }
                --lastExpanded;
                continue;
            }
            lastPattern = lastExpanded;
        }
        for (i = 0; i <= lastExpanded; ++i) {
            buf.append(expanded[i]);
            buf.append(nl);
        }
        if (lines.length == 0) {
            buf.append(nl);
        }
        return buf.toString();
    }

    private String loadDrlFile(Reader drl) throws IOException {
        String line;
        StringBuilder buf = new StringBuilder();
        BufferedReader input = new BufferedReader(drl);
        while ((line = input.readLine()) != null) {
            buf.append(line);
            buf.append(nl);
        }
        return buf.toString();
    }

    private void addError(ExpanderException error) {
        if (this.errors == Collections.EMPTY_LIST) {
            this.errors = new ArrayList<ExpanderException>();
        }
        this.errors.add(error);
    }

    @Override
    public List<ExpanderException> getErrors() {
        return this.errors;
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    private static class ConstraintInformation {
        int start = -1;
        int end = -1;
        String constraints = "";

        private ConstraintInformation() {
        }

        static ConstraintInformation findConstraintInformationInPattern(String pattern) {
            ConstraintInformation ci = new ConstraintInformation();
            int bracketCount = 0;
            for (int i = 0; i < pattern.length(); ++i) {
                char c = pattern.charAt(i);
                if (c == '(') {
                    if (bracketCount == 0) {
                        ci.start = i + 1;
                    }
                    ++bracketCount;
                }
                if (c != ')' || --bracketCount != 0) continue;
                ci.end = i;
                ci.constraints = pattern.substring(ci.start, ci.end);
                return ci;
            }
            return ci;
        }
    }
}

