/*
 * Decompiled with CFR 0.152.
 */
package org.drools.compiler.testframework;

import java.util.HashSet;
import java.util.Set;
import org.kie.api.event.rule.AfterMatchFiredEvent;
import org.kie.api.event.rule.AgendaEventListener;
import org.kie.api.event.rule.AgendaGroupPoppedEvent;
import org.kie.api.event.rule.AgendaGroupPushedEvent;
import org.kie.api.event.rule.BeforeMatchFiredEvent;
import org.kie.api.event.rule.MatchCancelledEvent;
import org.kie.api.event.rule.MatchCreatedEvent;
import org.kie.api.event.rule.RuleFlowGroupActivatedEvent;
import org.kie.api.event.rule.RuleFlowGroupDeactivatedEvent;

public class RuleCoverageListener
implements AgendaEventListener {
    private final Set<String> rules;
    private int totalCount;

    public RuleCoverageListener(HashSet<String> expectedRuleNames) {
        this.rules = expectedRuleNames;
        this.totalCount = expectedRuleNames.size();
    }

    @Override
    public void matchCancelled(MatchCancelledEvent event) {
    }

    @Override
    public void matchCreated(MatchCreatedEvent event) {
    }

    @Override
    public void afterMatchFired(AfterMatchFiredEvent event) {
        this.rules.remove(event.getMatch().getRule().getName());
    }

    @Override
    public void agendaGroupPopped(AgendaGroupPoppedEvent event) {
    }

    @Override
    public void agendaGroupPushed(AgendaGroupPushedEvent event) {
    }

    @Override
    public void beforeMatchFired(BeforeMatchFiredEvent event) {
    }

    public Set<String> getRules() {
        return this.rules;
    }

    public String[] getUnfiredRules() {
        return this.rules.toArray(new String[this.rules.size()]);
    }

    public int getPercentCovered() {
        float left = this.totalCount - this.rules.size();
        return (int)(left / (float)this.totalCount * 100.0f);
    }

    @Override
    public void afterRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    @Override
    public void afterRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }

    @Override
    public void beforeRuleFlowGroupActivated(RuleFlowGroupActivatedEvent event) {
    }

    @Override
    public void beforeRuleFlowGroupDeactivated(RuleFlowGroupDeactivatedEvent event) {
    }
}

