/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.security.AccessController;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.drools.core.base.AccessorKey;
import org.drools.core.base.BaseClassFieldReader;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ClassFieldInspector;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.base.ClassFieldWriter;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.FieldAccessorFactory;
import org.drools.core.util.ClassUtils;
import org.drools.reflective.ComponentsFactory;
import org.drools.reflective.util.ByteArrayClassLoader;

public class ClassFieldAccessorCache {
    private Map<ClassLoader, CacheEntry> cacheByClassLoader = new WeakHashMap<ClassLoader, CacheEntry>();
    private ClassLoader classLoader;

    public ClassFieldAccessorCache(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public ClassObjectType getClassObjectType(ClassObjectType objectType, boolean lookupClass) {
        Class cls = lookupClass ? this.getClass(objectType.getClassName()) : objectType.getClassType();
        CacheEntry cache = this.getCacheEntry(cls);
        return cache.getClassObjectType(cls, objectType);
    }

    public BaseClassFieldReader getReadAcessor(ClassFieldReader reader) {
        Class cls = this.getClass(reader.getClassName());
        return this.getCacheEntry(cls).getReadAccessor(this.getAccessorKey(reader), cls);
    }

    public void setReadAcessor(ClassFieldReader reader, BaseClassFieldReader readAccessor) {
        Class cls = this.getClass(reader.getClassName());
        this.getCacheEntry(cls).setReadAccessor(this.getAccessorKey(reader), readAccessor);
    }

    private AccessorKey getAccessorKey(ClassFieldReader reader) {
        String className = reader.getClassName();
        String fieldName = reader.getFieldName();
        return new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
    }

    public BaseClassFieldWriter getWriteAcessor(ClassFieldWriter writer) {
        Class cls = this.getClass(writer.getClassName());
        return this.getCacheEntry(cls).getWriteAccessor(this.getAccessorKey(writer), cls);
    }

    public void setWriteAcessor(ClassFieldWriter writer, BaseClassFieldWriter writeAccessor) {
        Class cls = this.getClass(writer.getClassName());
        this.getCacheEntry(cls).setWriteAccessor(this.getAccessorKey(writer), writeAccessor);
    }

    private AccessorKey getAccessorKey(ClassFieldWriter writer) {
        String className = writer.getClassName();
        String fieldName = writer.getFieldName();
        return new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
    }

    public Class getClass(String className) {
        try {
            Class<?> primitiveType = ClassUtils.convertPrimitiveNameToType(className);
            return primitiveType != null ? primitiveType : this.classLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to resolve class '" + className + "'");
        }
    }

    public CacheEntry getCacheEntry(Class cls) {
        ClassLoader cl = cls.getClassLoader() != null ? cls.getClassLoader() : this.classLoader;
        CacheEntry cache = this.cacheByClassLoader.get(cl);
        if (cache == null) {
            cache = new CacheEntry(this.classLoader);
            this.cacheByClassLoader.put(cl, cache);
        }
        return cache;
    }

    public static class CacheEntry {
        private final ByteArrayClassLoader byteArrayClassLoader;
        private final ConcurrentMap<AccessorKey, BaseClassFieldReader> readCache = new ConcurrentHashMap<AccessorKey, BaseClassFieldReader>();
        private final ConcurrentMap<AccessorKey, BaseClassFieldWriter> writeCache = new ConcurrentHashMap<AccessorKey, BaseClassFieldWriter>();
        private final ConcurrentMap<Class<?>, ClassFieldInspector> inspectors = new ConcurrentHashMap();
        private final ConcurrentMap<ClassObjectTypeKey, ClassObjectType> objectTypes = new ConcurrentHashMap<ClassObjectTypeKey, ClassObjectType>();

        public CacheEntry(ClassLoader parentClassLoader) {
            if (parentClassLoader == null) {
                throw new RuntimeException("ClassFieldAccessorFactory cannot have a null parent ClassLoader");
            }
            this.byteArrayClassLoader = AccessController.doPrivileged(() -> ComponentsFactory.createByteArrayClassLoader(parentClassLoader));
        }

        public ByteArrayClassLoader getByteArrayClassLoader() {
            return this.byteArrayClassLoader;
        }

        public BaseClassFieldReader getReadAccessor(AccessorKey key, Class cls) {
            BaseClassFieldReader existingReader;
            BaseClassFieldReader reader = (BaseClassFieldReader)this.readCache.get(key);
            if (reader == null && (reader = FieldAccessorFactory.get().getClassFieldReader(cls, key.getFieldName(), this)) != null && (existingReader = this.readCache.putIfAbsent(key, reader)) != null) {
                reader = existingReader;
            }
            return reader;
        }

        public void setReadAccessor(AccessorKey key, BaseClassFieldReader reader) {
            this.readCache.put(key, reader);
        }

        public BaseClassFieldWriter getWriteAccessor(AccessorKey key, Class cls) {
            BaseClassFieldWriter existingWriter;
            BaseClassFieldWriter writer = (BaseClassFieldWriter)this.writeCache.get(key);
            if (writer == null && (writer = FieldAccessorFactory.get().getClassFieldWriter(cls, key.getFieldName(), this)) != null && (existingWriter = this.writeCache.putIfAbsent(key, writer)) != null) {
                writer = existingWriter;
            }
            return writer;
        }

        public void setWriteAccessor(AccessorKey key, BaseClassFieldWriter writer) {
            this.writeCache.put(key, writer);
        }

        public Map<Class<?>, ClassFieldInspector> getInspectors() {
            return this.inspectors;
        }

        public ClassObjectType getClassObjectType(Class<?> cls, ClassObjectType objectType) {
            ClassObjectTypeKey key = new ClassObjectTypeKey(cls, objectType.isEvent());
            ClassObjectType existing = (ClassObjectType)this.objectTypes.get(key);
            if (existing == null) {
                objectType.setClassType(cls);
                existing = this.objectTypes.putIfAbsent(key, objectType);
                if (existing == null) {
                    existing = objectType;
                }
            }
            return existing;
        }
    }

    public static class ClassObjectTypeKey {
        private Class cls;
        private boolean event;

        public ClassObjectTypeKey(Class cls, boolean event) {
            this.cls = cls;
            this.event = event;
        }

        public Class getCls() {
            return this.cls;
        }

        public boolean isEvent() {
            return this.event;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.cls == null ? 0 : this.cls.hashCode());
            result = 31 * result + (this.event ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof ClassObjectTypeKey)) {
                return false;
            }
            ClassObjectTypeKey other = (ClassObjectTypeKey)obj;
            if (this.cls == null ? other.cls != null : !this.cls.equals(other.cls)) {
                return false;
            }
            return this.event == other.event;
        }
    }
}

