/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.base;

import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.drools.core.base.ClassFieldInspector;
import org.drools.core.base.ClassFieldReader;
import org.drools.core.kie.impl.MessageImpl;
import org.kie.api.io.Resource;
import org.kie.internal.builder.InternalMessage;
import org.kie.internal.builder.KnowledgeBuilderResult;
import org.kie.internal.builder.ResultSeverity;

public class IntrospectiveClassFieldInspector
implements ClassFieldInspector {
    private final Class<?> classUnderInspection;
    private final Map<String, Integer> fieldNames = new HashMap<String, Integer>();
    private final Map<String, Class<?>> fieldTypes = new HashMap();
    private final Map<String, Field> fieldTypesField = new HashMap<String, Field>();
    private final Map<String, Method> getterMethods = new HashMap<String, Method>();
    private final Map<String, Method> setterMethods = new HashMap<String, Method>();
    private final Set<String> nonGetters = new HashSet<String>();
    private Map<String, Collection<KnowledgeBuilderResult>> results = null;

    public IntrospectiveClassFieldInspector(Class<?> classUnderInspection) throws IOException {
        this(classUnderInspection, true);
    }

    public IntrospectiveClassFieldInspector(Class<?> classUnderInspection, boolean includeFinalMethods) throws IOException {
        this.classUnderInspection = classUnderInspection;
        this.processClassWithoutByteCode(classUnderInspection, includeFinalMethods);
    }

    private void processClassWithoutByteCode(Class<?> clazz, boolean includeFinalMethods) {
        List<Method> methods = Arrays.asList(clazz.getMethods());
        Collections.sort(methods, new Comparator<Method>(){

            @Override
            public int compare(Method m1, Method m22) {
                String n2;
                String n1 = m1.getName();
                if (n1.equals(n2 = m22.getName()) && m1.getDeclaringClass() != m22.getDeclaringClass()) {
                    return m1.getDeclaringClass().isAssignableFrom(m22.getDeclaringClass()) ? -1 : 1;
                }
                return n1.compareTo(n2);
            }
        });
        for (Method method : methods) {
            int fieldIndex;
            if (!this.acceptMethod(method, includeFinalMethods)) continue;
            if (!(method.getParameterTypes().length != 0 || method.getName().equals("<init>") || method.getName().equals("<clinit>") || method.getReturnType() == Void.TYPE || method.isDefault())) {
                fieldIndex = this.fieldNames.size();
                this.addToMapping(method, fieldIndex);
                continue;
            }
            if (method.getParameterTypes().length != 1 || !method.getName().startsWith("set")) continue;
            fieldIndex = this.fieldNames.size();
            this.addToMapping(method, fieldIndex);
        }
        List<Field> flds = Arrays.asList(clazz.getFields());
        Collections.sort(flds, new Comparator<Field>(){

            @Override
            public int compare(Field f1, Field f2) {
                return f1.getName().compareTo(f2.getName());
            }
        });
        for (Field fld : flds) {
            if (Modifier.isStatic(fld.getModifiers()) || this.fieldNames.containsKey(fld.getName())) continue;
            int fieldIndex = this.fieldNames.size();
            this.fieldNames.put(fld.getName(), fieldIndex);
            this.fieldTypes.put(fld.getName(), fld.getType());
            this.fieldTypesField.put(fld.getName(), fld);
        }
    }

    private boolean acceptMethod(Method method, boolean includeFinalMethods) {
        int modifiers = method.getModifiers();
        if (!Modifier.isPublic(modifiers)) {
            return false;
        }
        return includeFinalMethods || !Modifier.isFinal(modifiers);
    }

    @Override
    public Map<String, Integer> getFieldNames() {
        return this.fieldNames;
    }

    @Override
    public boolean isNonGetter(String name) {
        return this.nonGetters.contains(name);
    }

    @Override
    public Map<String, Field> getFieldTypesField() {
        return this.fieldTypesField;
    }

    @Override
    public Map<String, Class<?>> getFieldTypes() {
        return this.fieldTypes;
    }

    @Override
    public Class<?> getFieldType(String name) {
        return this.fieldTypes.get(name);
    }

    @Override
    public Map<String, Method> getGetterMethods() {
        return this.getterMethods;
    }

    @Override
    public Map<String, Method> getSetterMethods() {
        return this.setterMethods;
    }

    private void addToMapping(Method method, int index) {
        String name;
        int offset = (name = method.getName()).startsWith("is") ? 2 : (name.startsWith("get") || name.startsWith("set") ? 3 : 0);
        String fieldName = this.calcFieldName(name, offset);
        if (this.fieldNames.containsKey(fieldName)) {
            if (offset != 0 && this.nonGetters.contains(fieldName)) {
                Integer oldIndex = this.removeOldField(fieldName);
                this.storeField(oldIndex, fieldName);
                this.storeGetterSetter(method, fieldName);
                this.nonGetters.remove(fieldName);
            } else if (offset != 0) {
                this.storeGetterSetter(method, fieldName);
            }
        } else {
            this.storeField(index, fieldName);
            this.storeGetterSetter(method, fieldName);
            if (offset == 0) {
                this.nonGetters.add(fieldName);
            }
        }
    }

    private Integer removeOldField(String fieldName) {
        Integer index = this.fieldNames.remove(fieldName);
        this.fieldTypes.remove(fieldName);
        this.getterMethods.remove(fieldName);
        return index;
    }

    private void storeField(Integer index, String fieldName) {
        this.fieldNames.put(fieldName, index);
    }

    private Map<String, Field> getAllFields(Class<?> type) {
        HashMap<String, Field> fields = new HashMap<String, Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            for (Field f : c.getDeclaredFields()) {
                fields.put(f.getName(), f);
            }
        }
        return fields;
    }

    private void storeGetterSetter(Method method, String fieldName) {
        Field f = this.getAllFields(this.classUnderInspection).get(fieldName);
        if (method.getName().startsWith("set") && method.getParameterTypes().length == 1) {
            this.setterMethods.put(fieldName, method);
            if (!this.fieldTypes.containsKey(fieldName)) {
                this.fieldTypes.put(fieldName, method.getParameterTypes()[0]);
            }
            if (!this.fieldTypesField.containsKey(fieldName)) {
                this.fieldTypesField.put(fieldName, f);
            }
        } else if (!Void.TYPE.isAssignableFrom(method.getReturnType())) {
            Method existingMethod = this.getterMethods.get(fieldName);
            if (existingMethod != null && !this.isOverride(existingMethod, method)) {
                if (method.getReturnType() != existingMethod.getReturnType() && method.getReturnType().isAssignableFrom(existingMethod.getReturnType())) {
                    return;
                }
                this.addResult(fieldName, new GetterOverloadWarning(this.classUnderInspection, this.getterMethods.get(fieldName).getName(), this.fieldTypes.get(fieldName), method.getName(), method.getReturnType()));
            }
            this.getterMethods.put(fieldName, method);
            this.fieldTypes.put(fieldName, method.getReturnType());
            this.fieldTypesField.put(fieldName, f);
        }
    }

    private boolean isOverride(Method oldMethod, Method newMethod) {
        return !oldMethod.getDeclaringClass().equals(newMethod.getDeclaringClass()) && oldMethod.getDeclaringClass().isAssignableFrom(newMethod.getDeclaringClass());
    }

    private String calcFieldName(String name, int offset) {
        name = name.substring(offset);
        return ClassFieldReader.decapitalizeFieldName(name);
    }

    @Override
    public Collection<KnowledgeBuilderResult> getInspectionResults(String fieldName) {
        return this.results != null && this.results.containsKey(fieldName) ? this.results.get(fieldName) : Collections.EMPTY_LIST;
    }

    private void addResult(String fieldName, KnowledgeBuilderResult result) {
        Map<String, Collection<KnowledgeBuilderResult>> results = this.getResults();
        Collection<KnowledgeBuilderResult> fieldResults = results.get(fieldName);
        if (fieldResults == null) {
            fieldResults = new ArrayList<KnowledgeBuilderResult>(3);
            results.put(fieldName, fieldResults);
        }
        fieldResults.add(result);
    }

    protected Map<String, Collection<KnowledgeBuilderResult>> getResults() {
        if (this.results == null) {
            this.results = new HashMap<String, Collection<KnowledgeBuilderResult>>();
        }
        return this.results;
    }

    public static class GetterOverloadWarning
    implements KnowledgeBuilderResult {
        private Class klass;
        private String oldName;
        private Class oldType;
        private String newName;
        private Class newType;

        public GetterOverloadWarning(Class klass, String oldName, Class oldType, String newName, Class newType) {
            this.klass = klass;
            this.oldName = oldName;
            this.oldType = oldType;
            this.newName = newName;
            this.newType = newType;
        }

        @Override
        public ResultSeverity getSeverity() {
            return ResultSeverity.WARNING;
        }

        @Override
        public String getMessage() {
            return " Getter overloading detected in class " + this.klass.getName() + " : " + this.oldName + " (" + this.oldType + ") vs " + this.newName + " (" + this.newType + ") ";
        }

        @Override
        public int[] getLines() {
            return new int[0];
        }

        @Override
        public Resource getResource() {
            return null;
        }

        @Override
        public InternalMessage asMessage(long id) {
            return new MessageImpl(id, this);
        }
    }
}

