/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event;

import java.util.List;
import java.util.Map;
import org.drools.core.common.InternalKnowledgeRuntime;
import org.drools.core.event.AbstractEventSupport;
import org.drools.core.event.MessageEventImpl;
import org.drools.core.event.ProcessAsyncNodeScheduledEventImpl;
import org.drools.core.event.ProcessCompletedEventImpl;
import org.drools.core.event.ProcessNodeLeftEventImpl;
import org.drools.core.event.ProcessNodeTriggeredEventImpl;
import org.drools.core.event.ProcessStartedEventImpl;
import org.drools.core.event.ProcessVariableChangedEventImpl;
import org.drools.core.event.SLAViolatedEventImpl;
import org.drools.core.event.SignalEventImpl;
import org.kie.api.event.process.ProcessAsyncNodeScheduledEvent;
import org.kie.api.event.process.ProcessCompletedEvent;
import org.kie.api.event.process.ProcessEventListener;
import org.kie.api.event.process.ProcessNodeLeftEvent;
import org.kie.api.event.process.ProcessNodeTriggeredEvent;
import org.kie.api.event.process.ProcessStartedEvent;
import org.kie.api.event.process.ProcessVariableChangedEvent;
import org.kie.api.event.process.SLAViolatedEvent;
import org.kie.api.runtime.KieRuntime;
import org.kie.api.runtime.process.NodeInstance;
import org.kie.api.runtime.process.ProcessInstance;

public class ProcessEventSupport
extends AbstractEventSupport<ProcessEventListener> {
    public void fireBeforeProcessStarted(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessStartedEventImpl event = new ProcessStartedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeProcessStarted((ProcessStartedEvent)e));
        }
    }

    public void fireAfterProcessStarted(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessStartedEventImpl event = new ProcessStartedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterProcessStarted((ProcessStartedEvent)e));
        }
    }

    public void fireBeforeProcessCompleted(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessCompletedEventImpl event = new ProcessCompletedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeProcessCompleted((ProcessCompletedEvent)e));
        }
    }

    public void fireAfterProcessCompleted(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessCompletedEventImpl event = new ProcessCompletedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterProcessCompleted((ProcessCompletedEvent)e));
        }
    }

    public void fireOnAsyncNodeScheduledEvent(NodeInstance nodeInstance, InternalKnowledgeRuntime kruntime, Map<String, Object> data) {
        if (this.hasListeners()) {
            ProcessAsyncNodeScheduledEventImpl event = new ProcessAsyncNodeScheduledEventImpl(nodeInstance, kruntime, data);
            this.notifyAllListeners(event, (l, e) -> l.onAsyncNodeScheduledEvent((ProcessAsyncNodeScheduledEvent)e));
        }
    }

    public void fireBeforeNodeTriggered(NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessNodeTriggeredEventImpl event = new ProcessNodeTriggeredEventImpl(nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeNodeTriggered((ProcessNodeTriggeredEvent)e));
        }
    }

    public void fireAfterNodeTriggered(NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessNodeTriggeredEventImpl event = new ProcessNodeTriggeredEventImpl(nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterNodeTriggered((ProcessNodeTriggeredEvent)e));
        }
    }

    public void fireBeforeNodeLeft(NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessNodeLeftEventImpl event = new ProcessNodeLeftEventImpl(nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeNodeLeft((ProcessNodeLeftEvent)e));
        }
    }

    public void fireAfterNodeLeft(NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessNodeLeftEventImpl event = new ProcessNodeLeftEventImpl(nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterNodeLeft((ProcessNodeLeftEvent)e));
        }
    }

    public void fireBeforeVariableChanged(String id, String instanceId, Object oldValue, Object newValue, List<String> tags, ProcessInstance processInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessVariableChangedEventImpl event = new ProcessVariableChangedEventImpl(id, instanceId, oldValue, newValue, tags, processInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeVariableChanged((ProcessVariableChangedEvent)e));
        }
    }

    public void fireAfterVariableChanged(String name, String id, Object oldValue, Object newValue, List<String> tags, ProcessInstance processInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            ProcessVariableChangedEventImpl event = new ProcessVariableChangedEventImpl(name, id, oldValue, newValue, tags, processInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterVariableChanged((ProcessVariableChangedEvent)e));
        }
    }

    public void fireBeforeSLAViolated(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeSLAViolated((SLAViolatedEvent)e));
        }
    }

    public void fireAfterSLAViolated(ProcessInstance instance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterSLAViolated((SLAViolatedEvent)e));
        }
    }

    public void fireBeforeSLAViolated(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.beforeSLAViolated((SLAViolatedEvent)e));
        }
    }

    public void fireAfterSLAViolated(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime) {
        if (this.hasListeners()) {
            SLAViolatedEventImpl event = new SLAViolatedEventImpl(instance, nodeInstance, kruntime);
            this.notifyAllListeners(event, (l, e) -> l.afterSLAViolated((SLAViolatedEvent)e));
        }
    }

    public void fireOnSignal(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime, String signalName, Object signalObject) {
        if (this.hasListeners()) {
            SignalEventImpl event = new SignalEventImpl(instance, kruntime, nodeInstance, signalName, signalObject);
            this.notifyAllListeners(event, ProcessEventListener::onSignal);
        }
    }

    public void fireOnMessage(ProcessInstance instance, NodeInstance nodeInstance, KieRuntime kruntime, String messageName, Object messageObject) {
        if (this.hasListeners()) {
            MessageEventImpl event = new MessageEventImpl(instance, kruntime, nodeInstance, messageName, messageObject);
            this.notifyAllListeners(event, ProcessEventListener::onMessage);
        }
    }

    public void reset() {
        this.clear();
    }
}

