/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.event.rule.impl;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.AgendaItemImpl;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.RuleTerminalNodeLeftTuple;
import org.drools.core.rule.Declaration;
import org.drools.core.spi.Activation;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.Tuple;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.FactHandle;
import org.kie.api.runtime.rule.Match;

public class SerializableActivation
implements Match,
Externalizable {
    private Rule rule;
    private Map<Declaration, Object> declarations;
    private PropagationContext propgationContext;
    private boolean active;

    public SerializableActivation() {
    }

    public SerializableActivation(Match activation) {
        this.rule = activation.getRule();
        this.propgationContext = ((Activation)activation).getPropagationContext();
        if (activation instanceof AgendaItemImpl) {
            Tuple tuple = ((AgendaItem)activation).getTuple();
            this.declarations = this.extractObjectsFromDeclaration(tuple, ((RuleTerminalNode)tuple.getTupleSink()).getAllDeclarations());
        } else if (activation instanceof SerializableActivation) {
            this.declarations = ((SerializableActivation)activation).declarations;
        } else if (activation instanceof RuleTerminalNodeLeftTuple) {
            RuleTerminalNodeLeftTuple tuple = (RuleTerminalNodeLeftTuple)activation;
            this.declarations = this.extractObjectsFromDeclaration(tuple, ((RuleTerminalNode)tuple.getTupleSink()).getAllDeclarations());
        } else {
            throw new RuntimeException("Unable to get declarations " + activation);
        }
        this.active = ((Activation)activation).isQueued();
    }

    private Map<Declaration, Object> extractObjectsFromDeclaration(Tuple tuple, Declaration[] declarationsArray) {
        HashMap<Declaration, Object> declarations = new HashMap<Declaration, Object>();
        for (Declaration declaration : declarationsArray) {
            declarations.put(declaration, tuple.get(declaration).getObject());
        }
        return declarations;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.rule = (Rule)in.readObject();
        this.propgationContext = (PropagationContext)in.readObject();
        this.declarations = (Map)in.readObject();
        this.active = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.rule);
        out.writeObject(this.propgationContext);
        out.writeObject(this.declarations);
        out.writeBoolean(this.active);
    }

    @Override
    public Rule getRule() {
        return this.rule;
    }

    @Override
    public List<? extends FactHandle> getFactHandles() {
        throw new UnsupportedOperationException();
    }

    public PropagationContext getPropagationContext() {
        return this.propgationContext;
    }

    @Override
    public List<Object> getObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object getDeclarationValue(String variableName) {
        throw new UnsupportedOperationException();
    }

    public Collection<Declaration> getDeclarations() {
        return this.declarations.keySet();
    }

    public Object getObject(Declaration declaration) {
        return this.declarations.get(declaration);
    }

    @Override
    public List<String> getDeclarationIds() {
        ArrayList<String> decls = new ArrayList<String>();
        for (Declaration decl : this.declarations.keySet()) {
            decls.add(decl.getIdentifier());
        }
        return Collections.unmodifiableList(decls);
    }

    public boolean isActive() {
        return this.active;
    }
}

