/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.Collection;
import java.util.Iterator;
import org.drools.core.phreak.AbstractReactiveObject;
import org.drools.core.phreak.ReactiveObject;
import org.drools.core.phreak.ReactiveObjectUtil;
import org.drools.core.spi.Tuple;

public class ReactiveCollection<T, W extends Collection<T>>
extends AbstractReactiveObject
implements Collection<T> {
    protected final W wrapped;

    public ReactiveCollection(W wrapped) {
        this.wrapped = wrapped;
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.wrapped.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.wrapped.toArray(a);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    @Override
    public boolean add(T t2) {
        boolean result = this.wrapped.add(t2);
        if (result) {
            ReactiveObjectUtil.notifyModification(t2, this.getLeftTuples(), ReactiveObjectUtil.ModificationType.ADD);
            if (t2 instanceof ReactiveObject) {
                for (Tuple lts : this.getLeftTuples()) {
                    ((ReactiveObject)t2).addLeftTuple(lts);
                }
            }
        }
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean result = false;
        for (T elem : c) {
            result |= this.add(elem);
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = false;
        for (Object elem : c) {
            result |= this.remove(elem);
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = false;
        for (Object elem : this.wrapped) {
            if (c.contains(elem)) continue;
            result |= this.remove(elem);
        }
        return result;
    }

    @Override
    public void clear() {
        for (Object elem : this.wrapped) {
            this.wrapped.remove(elem);
        }
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.wrapped.remove(o);
        if (result) {
            if (o instanceof ReactiveObject) {
                for (Tuple lts : this.getLeftTuples()) {
                    ((ReactiveObject)o).removeLeftTuple(lts);
                }
            }
            ReactiveObjectUtil.notifyModification(o, this.getLeftTuples(), ReactiveObjectUtil.ModificationType.REMOVE);
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new ReactiveIterator(this, this.wrapped.iterator());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReactiveCollection [").append(this.wrapped).append("]");
        return builder.toString();
    }

    protected static class ReactiveIterator<WI extends Iterator<T>>
    implements Iterator<T> {
        protected WI wrapped;
        protected T last;
        final /* synthetic */ ReactiveCollection this$0;

        public ReactiveIterator(WI wrapped) {
            this.this$0 = this$0;
            this.wrapped = wrapped;
        }

        @Override
        public boolean hasNext() {
            return this.wrapped.hasNext();
        }

        @Override
        public T next() {
            this.last = this.wrapped.next();
            return this.last;
        }

        @Override
        public void remove() {
            this.wrapped.remove();
            if (this.last != null) {
                if (this.last instanceof ReactiveObject) {
                    for (Tuple lts : this.this$0.getLeftTuples()) {
                        ((ReactiveObject)this.last).removeLeftTuple(lts);
                    }
                }
                ReactiveObjectUtil.notifyModification(this.last, this.this$0.getLeftTuples(), ReactiveObjectUtil.ModificationType.REMOVE);
                this.last = null;
            }
        }
    }
}

