/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.drools.core.reteoo.AsyncMessage;

public class AsyncMessagesCoordinator {
    private final Map<String, List<Consumer<AsyncMessage>>> listeners = new HashMap<String, List<Consumer<AsyncMessage>>>();

    private AsyncMessagesCoordinator() {
    }

    public static AsyncMessagesCoordinator get() {
        return Holder.INSTANCE;
    }

    public void propagate(String messageId, AsyncMessage leftTuple) {
        this.listeners.getOrDefault(messageId, Collections.emptyList()).forEach(c -> c.accept(leftTuple));
    }

    synchronized void registerReceiver(String messageId, Consumer<AsyncMessage> receiver) {
        this.listeners.computeIfAbsent(messageId, s2 -> new ArrayList()).add(receiver);
    }

    synchronized void deregisterReceiver(String messageId, Consumer<AsyncMessage> receiver) {
        List<Consumer<AsyncMessage>> consumers = this.listeners.get(messageId);
        consumers.remove(receiver);
        if (consumers.isEmpty()) {
            this.listeners.remove(messageId);
        }
    }

    public Map<String, List<Consumer<AsyncMessage>>> getListeners() {
        return this.listeners;
    }

    public static class Holder {
        private static final AsyncMessagesCoordinator INSTANCE = new AsyncMessagesCoordinator();
    }
}

