/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import org.drools.core.common.BaseNode;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NodeTypeEnums;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.Sink;
import org.kie.api.KieBase;

public class SegmentMemoryInitializer {
    public static void createAllSegmentPrototypes(KieBase kieBase) {
        InternalWorkingMemory wm = (InternalWorkingMemory)((Object)kieBase.newKieSession());
        Rete rete = ((InternalKnowledgeBase)kieBase).getRete();
        for (EntryPointNode entryPointNode : rete.getEntryPointNodes().values()) {
            SegmentMemoryInitializer.visitNode(wm, entryPointNode);
        }
    }

    private static void visitNode(InternalWorkingMemory wm, BaseNode node) {
        Sink[] sinks = node.getSinks();
        if (sinks != null) {
            for (Sink sink : sinks) {
                if (sink instanceof LeftInputAdapterNode) {
                    SegmentMemoryInitializer.visitSegmentRoot(wm, (LeftInputAdapterNode)sink);
                    continue;
                }
                if (NodeTypeEnums.isBetaNode(sink) || !(sink instanceof BaseNode)) continue;
                SegmentMemoryInitializer.visitNode(wm, (BaseNode)((Object)sink));
            }
        }
    }

    private static void visitSegmentRoot(InternalWorkingMemory wm, LeftTupleSource rootNode) {
        Object nodeMem = wm.getNodeMemory((MemoryFactory)((Object)rootNode));
        SegmentMemory smem = nodeMem.getOrCreateSegmentMemory(rootNode, wm);
        BaseNode tipNode = (BaseNode)((Object)smem.getTipNode());
        Sink[] sinks = tipNode.getSinks();
        if (sinks != null) {
            for (Sink sink : sinks) {
                if (!(sink instanceof LeftTupleSource)) continue;
                SegmentMemoryInitializer.visitSegmentRoot(wm, (LeftTupleSource)((Object)sink));
            }
        }
    }
}

