/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScalablePool<T> {
    private static final Logger log = LoggerFactory.getLogger(ScalablePool.class);
    private final Queue<T> pool = new ConcurrentLinkedQueue<T>();
    private final List<T> resources = Collections.synchronizedList(new ArrayList());
    private final Supplier<? extends T> supplier;
    private final Consumer<? super T> resetter;
    private final Consumer<? super T> disposer;

    public ScalablePool(int initialSize, Supplier<? extends T> supplier, Consumer<? super T> resetter, Consumer<? super T> disposer) {
        this.supplier = supplier;
        this.resetter = resetter;
        this.disposer = disposer;
        for (int i = 0; i < initialSize; ++i) {
            T t2 = this.supplier.get();
            this.pool.offer(t2);
            this.resources.add(t2);
        }
    }

    public T get() {
        T t2 = this.pool.poll();
        if (t2 != null) {
            return t2;
        }
        t2 = this.supplier.get();
        this.resources.add(t2);
        return t2;
    }

    public void release(T t2) {
        this.resetter.accept(t2);
        this.pool.offer(t2);
    }

    public void shutdown() {
        for (T t2 : this.resources) {
            this.disposer.accept(t2);
        }
        this.pool.clear();
        this.resources.clear();
    }
}

