/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.Iterator;
import org.drools.core.util.Triple;
import org.drools.core.util.TripleImpl;
import org.kie.api.runtime.rule.Variable;

public class TripleStore
extends AbstractHashTable
implements Externalizable {
    public static final String TYPE = "rdfs:type";
    public static final String PROXY = "drools:proxy";
    public static final String VALUE = "drools:hasValue";
    private String id;

    public TripleStore() {
        this.comparator = new TripleKeyComparator();
    }

    public TripleStore(int capacity, float loadFactor) {
        super(capacity, loadFactor);
        this.comparator = new TripleKeyComparator();
    }

    public TripleStore(Entry[] table) {
        super(table);
        this.comparator = new TripleKeyComparator();
    }

    public TripleStore(float loadFactor, Entry[] table) {
        super(loadFactor, table);
        this.comparator = new TripleKeyComparator();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.id = (String)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.id);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean put(Triple triple) {
        return this.put(triple, true);
    }

    public boolean add(Triple triple) {
        return this.put(triple, false);
    }

    public boolean put(Triple triple, boolean checkExists) {
        int hashCode = this.comparator.hashCodeOf(triple);
        int index = TripleStore.indexOf(hashCode, this.table.length);
        if (checkExists) {
            Object val = triple.getValue();
            ((TripleImpl)triple).setValue(Variable.v);
            for (TripleImpl current = (TripleImpl)this.table[index]; current != null; current = (TripleImpl)current.getNext()) {
                if (hashCode != this.comparator.hashCodeOf(current) || !this.comparator.areEqual(triple, current)) continue;
                current.setValue(val);
                return true;
            }
            ((TripleImpl)triple).setValue(val);
        }
        TripleImpl timpl = (TripleImpl)triple;
        timpl.setNext(this.table[index]);
        this.table[index] = timpl;
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
        return false;
    }

    public Triple get(Triple triple) {
        int hashCode = this.comparator.hashCodeOf(triple);
        int index = TripleStore.indexOf(hashCode, this.table.length);
        for (TripleImpl current = (TripleImpl)this.table[index]; current != null; current = (TripleImpl)current.getNext()) {
            if (hashCode != this.comparator.hashCodeOf(current) || !this.comparator.areEqual(triple, current)) continue;
            return current;
        }
        return null;
    }

    public Collection<Triple> getAll(Triple triple) {
        Triple tx;
        ArrayList<Triple> list = new ArrayList<Triple>();
        if (triple.getInstance() != Variable.v && triple.getProperty() != Variable.v) {
            Triple t2 = this.get(triple);
            if (t2 != null) {
                for (Triple current = t2; current != null; current = (Triple)current.getNext()) {
                    if (!this.comparator.areEqual(triple, current)) continue;
                    list.add(current);
                }
            }
            return list;
        }
        Iterator iter = this.iterator();
        while ((tx = (Triple)iter.next()) != null) {
            if (!this.comparator.areEqual(triple, tx)) continue;
            list.add(tx);
        }
        return list;
    }

    public int removeAll(Triple triple) {
        int removed = 0;
        Collection<Triple> coll = this.getAll(triple);
        for (Triple t2 : coll) {
            if (!this.remove(t2)) continue;
            ++removed;
        }
        return removed;
    }

    public boolean remove(Triple triple) {
        TripleImpl previous;
        int hashCode = this.comparator.hashCodeOf(triple);
        int index = TripleStore.indexOf(hashCode, this.table.length);
        TripleImpl current = previous = (TripleImpl)this.table[index];
        TripleImpl key = new TripleImpl(triple.getInstance(), triple.getProperty(), (Object)Variable.v);
        while (current != null) {
            TripleImpl next = (TripleImpl)current.getNext();
            if (hashCode == this.comparator.hashCodeOf(current) && this.comparator.areEqual(key, current) && (current.getValue() == null && triple.getValue() == null || current.getValue() != null && current.getValue().equals(triple.getValue()))) {
                if (previous == current) {
                    this.table[index] = next;
                } else {
                    previous.setNext(next);
                }
                current.setNext(null);
                --this.size;
                return true;
            }
            previous = current;
            current = next;
        }
        return false;
    }

    public boolean contains(Triple triple) {
        int hashCode = this.comparator.hashCodeOf(triple);
        int index = TripleStore.indexOf(hashCode, this.table.length);
        for (TripleImpl current = (TripleImpl)this.table[index]; current != null; current = (TripleImpl)current.getNext()) {
            if (hashCode != this.comparator.hashCodeOf(current) || !this.comparator.areEqual(triple, current)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getResizeHashcode(Entry entry) {
        return this.comparator.hashCodeOf(entry);
    }

    public static class TripleKeyComparator
    implements AbstractHashTable.ObjectComparator {
        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public int hashCodeOf(Object object) {
            Triple t2 = (Triple)object;
            int prime = 31;
            int result = 1;
            result = 31 * result + t2.getInstance().hashCode();
            result = 31 * result + t2.getProperty().hashCode();
            return result;
        }

        public int rehash(int h2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean areEqual(Object object1, Object object2) {
            Triple t1 = (Triple)object1;
            Triple t2 = (Triple)object2;
            if (t1.getInstance() != Variable.v) {
                if (t1.getInstance() == null) {
                    return false;
                }
                if (t1.getInstance() instanceof String ? !t1.getInstance().equals(t2.getInstance()) : t1.getInstance() != t2.getInstance()) {
                    return false;
                }
            }
            if (t1.getProperty() != Variable.v && !t1.getProperty().equals(t2.getProperty())) {
                return false;
            }
            if (t1.getValue() != Variable.v) {
                if (t1.getValue() == null) {
                    return t2.getValue() == null;
                }
                return t1.getValue().equals(t2.getValue());
            }
            return true;
        }
    }
}

