/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.util.bitmask;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import org.drools.core.util.bitmask.AllSetBitMask;
import org.drools.core.util.bitmask.AllSetButLastBitMask;
import org.drools.core.util.bitmask.BitMask;
import org.drools.core.util.bitmask.EmptyBitMask;
import org.drools.core.util.bitmask.EmptyButLastBitMask;
import org.drools.core.util.bitmask.LongBitMask;

public class OpenBitSet
implements BitMask {
    protected long[] bits;
    protected int wlen;
    private long numBits;
    public static final int NUM_BYTES_LONG = 8;
    public static final String OS_ARCH = System.getProperty("os.arch");
    public static final boolean JRE_IS_MINIMUM_JAVA7;
    public static final boolean JRE_IS_MINIMUM_JAVA8;
    public static final boolean JRE_IS_64BIT;

    public OpenBitSet(long numBits) {
        this.numBits = numBits;
        this.bits = new long[OpenBitSet.bits2words(numBits)];
        this.wlen = this.bits.length;
    }

    public OpenBitSet() {
        this(64L);
    }

    public OpenBitSet(long[] bits, int numWords) {
        this.bits = bits;
        this.wlen = numWords;
        this.numBits = this.wlen * 64;
    }

    public long capacity() {
        return this.bits.length << 6;
    }

    public long size() {
        return this.capacity();
    }

    public int length() {
        return this.bits.length << 6;
    }

    @Override
    public boolean isEmpty() {
        return this.cardinality() == 0L;
    }

    public long[] getBits() {
        return this.bits;
    }

    public void setBits(long[] bits) {
        this.bits = bits;
    }

    public int getNumWords() {
        return this.wlen;
    }

    public void setNumWords(int nWords) {
        this.wlen = nWords;
    }

    public boolean get(int index) {
        int i = index >> 6;
        if (i >= this.bits.length) {
            return false;
        }
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public boolean fastGet(int index) {
        assert (index >= 0 && (long)index < this.numBits);
        int i = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public boolean get(long index) {
        int i = (int)(index >> 6);
        if (i >= this.bits.length) {
            return false;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public boolean fastGet(long index) {
        assert (index >= 0L && index < this.numBits);
        int i = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        return (this.bits[i] & bitmask) != 0L;
    }

    public int getBit(int index) {
        assert (index >= 0 && (long)index < this.numBits);
        int i = index >> 6;
        int bit = index & 0x3F;
        return (int)(this.bits[i] >>> bit) & 1;
    }

    public void set(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void fastSet(int index) {
        assert (index >= 0 && (long)index < this.numBits);
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void fastSet(long index) {
        assert (index >= 0L && index < this.numBits);
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
    }

    public void set(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] | startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] | startmask;
        Arrays.fill(this.bits, startWord + 1, endWord, -1L);
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] | endmask;
    }

    protected int expandingWordNum(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.wlen) {
            this.ensureCapacity(index + 1L);
            this.wlen = wordNum + 1;
        }
        assert ((this.numBits = Math.max(this.numBits, index + 1L)) >= 0L);
        return wordNum;
    }

    public void fastClear(int index) {
        assert (index >= 0 && (long)index < this.numBits);
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void fastClear(long index) {
        assert (index >= 0L && index < this.numBits);
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(long index) {
        int wordNum = (int)(index >> 6);
        if (wordNum >= this.wlen) {
            return;
        }
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] & (bitmask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear(int startIndex, int endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = startIndex >> 6;
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = endIndex - 1 >> 6;
        long startmask = -1L << startIndex;
        long endmask = -1L >>> -endIndex;
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        Arrays.fill(this.bits, startWord + 1, middle, 0L);
        if (endWord < this.wlen) {
            int n2 = endWord;
            this.bits[n2] = this.bits[n2] & endmask;
        }
    }

    public void clear(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        if (startWord >= this.wlen) {
            return;
        }
        int endWord = (int)(endIndex - 1L >> 6);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        startmask ^= 0xFFFFFFFFFFFFFFFFL;
        endmask ^= 0xFFFFFFFFFFFFFFFFL;
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] & (startmask | endmask);
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] & startmask;
        int middle = Math.min(this.wlen, endWord);
        Arrays.fill(this.bits, startWord + 1, middle, 0L);
        if (endWord < this.wlen) {
            int n2 = endWord;
            this.bits[n2] = this.bits[n2] & endmask;
        }
    }

    public boolean getAndSet(int index) {
        assert (index >= 0 && (long)index < this.numBits);
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public boolean getAndSet(long index) {
        assert (index >= 0L && index < this.numBits);
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        boolean val = (this.bits[wordNum] & bitmask) != 0L;
        int n = wordNum;
        this.bits[n] = this.bits[n] | bitmask;
        return val;
    }

    public void fastFlip(int index) {
        assert (index >= 0 && (long)index < this.numBits);
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void fastFlip(long index) {
        assert (index >= 0L && index < this.numBits);
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public void flip(long index) {
        int wordNum = this.expandingWordNum(index);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
    }

    public boolean flipAndGet(int index) {
        assert (index >= 0 && (long)index < this.numBits);
        int wordNum = index >> 6;
        int bit = index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
        return (this.bits[wordNum] & bitmask) != 0L;
    }

    public boolean flipAndGet(long index) {
        assert (index >= 0L && index < this.numBits);
        int wordNum = (int)(index >> 6);
        int bit = (int)index & 0x3F;
        long bitmask = 1L << bit;
        int n = wordNum;
        this.bits[n] = this.bits[n] ^ bitmask;
        return (this.bits[wordNum] & bitmask) != 0L;
    }

    public void flip(long startIndex, long endIndex) {
        if (endIndex <= startIndex) {
            return;
        }
        int startWord = (int)(startIndex >> 6);
        int endWord = this.expandingWordNum(endIndex - 1L);
        long startmask = -1L << (int)startIndex;
        long endmask = -1L >>> (int)(-endIndex);
        if (startWord == endWord) {
            int n = startWord;
            this.bits[n] = this.bits[n] ^ startmask & endmask;
            return;
        }
        int n = startWord;
        this.bits[n] = this.bits[n] ^ startmask;
        for (int i = startWord + 1; i < endWord; ++i) {
            this.bits[i] = this.bits[i] ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n2 = endWord;
        this.bits[n2] = this.bits[n2] ^ endmask;
    }

    public long cardinality() {
        return BitUtil.pop_array(this.bits, 0, this.wlen);
    }

    public static long intersectionCount(OpenBitSet a, OpenBitSet b) {
        return BitUtil.pop_intersect(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
    }

    public static long unionCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_union(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen < b.wlen) {
            tot += BitUtil.pop_array(b.bits, a.wlen, b.wlen - a.wlen);
        } else if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public static long andNotCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_andnot(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public static long xorCount(OpenBitSet a, OpenBitSet b) {
        long tot = BitUtil.pop_xor(a.bits, b.bits, 0, Math.min(a.wlen, b.wlen));
        if (a.wlen < b.wlen) {
            tot += BitUtil.pop_array(b.bits, a.wlen, b.wlen - a.wlen);
        } else if (a.wlen > b.wlen) {
            tot += BitUtil.pop_array(a.bits, b.wlen, a.wlen - b.wlen);
        }
        return tot;
    }

    public int nextSetBit(int index) {
        int i = index >> 6;
        if (i >= this.wlen) {
            return -1;
        }
        int subIndex = index & 0x3F;
        long word = this.bits[i] >> subIndex;
        if (word != 0L) {
            return (i << 6) + subIndex + Long.numberOfTrailingZeros(word);
        }
        while (++i < this.wlen) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + Long.numberOfTrailingZeros(word);
        }
        return -1;
    }

    public long nextSetBit(long index) {
        int i = (int)(index >>> 6);
        if (i >= this.wlen) {
            return -1L;
        }
        int subIndex = (int)index & 0x3F;
        long word = this.bits[i] >>> subIndex;
        if (word != 0L) {
            return ((long)i << 6) + (long)(subIndex + Long.numberOfTrailingZeros(word));
        }
        while (++i < this.wlen) {
            word = this.bits[i];
            if (word == 0L) continue;
            return ((long)i << 6) + (long)Long.numberOfTrailingZeros(word);
        }
        return -1L;
    }

    public int prevSetBit(int index) {
        long word;
        int subIndex;
        int i = index >> 6;
        if (i >= this.wlen) {
            i = this.wlen - 1;
            if (i < 0) {
                return -1;
            }
            subIndex = 63;
            word = this.bits[i];
        } else {
            if (i < 0) {
                return -1;
            }
            subIndex = index & 0x3F;
            word = this.bits[i] << 63 - subIndex;
        }
        if (word != 0L) {
            return (i << 6) + subIndex - Long.numberOfLeadingZeros(word);
        }
        while (--i >= 0) {
            word = this.bits[i];
            if (word == 0L) continue;
            return (i << 6) + 63 - Long.numberOfLeadingZeros(word);
        }
        return -1;
    }

    public long prevSetBit(long index) {
        long word;
        int subIndex;
        int i = (int)(index >> 6);
        if (i >= this.wlen) {
            i = this.wlen - 1;
            if (i < 0) {
                return -1L;
            }
            subIndex = 63;
            word = this.bits[i];
        } else {
            if (i < 0) {
                return -1L;
            }
            subIndex = (int)index & 0x3F;
            word = this.bits[i] << 63 - subIndex;
        }
        if (word != 0L) {
            return ((long)i << 6) + (long)subIndex - (long)Long.numberOfLeadingZeros(word);
        }
        while (--i >= 0) {
            word = this.bits[i];
            if (word == 0L) continue;
            return ((long)i << 6) + 63L - (long)Long.numberOfLeadingZeros(word);
        }
        return -1L;
    }

    @Override
    public OpenBitSet clone() {
        try {
            OpenBitSet obs = (OpenBitSet)super.clone();
            obs.bits = (long[])obs.bits.clone();
            return obs;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public void intersect(OpenBitSet other) {
        int newLen = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = newLen;
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] & otherArr[pos];
        }
        if (this.wlen > newLen) {
            Arrays.fill(this.bits, newLen, this.wlen, 0L);
        }
        this.wlen = newLen;
    }

    public void union(OpenBitSet other) {
        int newLen = Math.max(this.wlen, other.wlen);
        this.ensureCapacityWords(newLen);
        assert ((this.numBits = Math.max(other.numBits, this.numBits)) >= 0L);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = Math.min(this.wlen, other.wlen);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] | otherArr[pos];
        }
        if (this.wlen < newLen) {
            System.arraycopy(otherArr, this.wlen, thisArr, this.wlen, newLen - this.wlen);
        }
        this.wlen = newLen;
    }

    public void remove(OpenBitSet other) {
        int idx = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        while (--idx >= 0) {
            int n = idx;
            thisArr[n] = thisArr[n] & (otherArr[idx] ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public void xor(OpenBitSet other) {
        int newLen = Math.max(this.wlen, other.wlen);
        this.ensureCapacityWords(newLen);
        assert ((this.numBits = Math.max(other.numBits, this.numBits)) >= 0L);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        int pos = Math.min(this.wlen, other.wlen);
        while (--pos >= 0) {
            int n = pos;
            thisArr[n] = thisArr[n] ^ otherArr[pos];
        }
        if (this.wlen < newLen) {
            System.arraycopy(otherArr, this.wlen, thisArr, this.wlen, newLen - this.wlen);
        }
        this.wlen = newLen;
    }

    public void and(OpenBitSet other) {
        this.intersect(other);
    }

    public void or(OpenBitSet other) {
        this.union(other);
    }

    public void andNot(OpenBitSet other) {
        this.remove(other);
    }

    public boolean intersects(OpenBitSet other) {
        int pos = Math.min(this.wlen, other.wlen);
        long[] thisArr = this.bits;
        long[] otherArr = other.bits;
        while (--pos >= 0) {
            if ((thisArr[pos] & otherArr[pos]) == 0L) continue;
            return true;
        }
        return false;
    }

    public void ensureCapacityWords(int numWords) {
        if (this.bits.length < numWords) {
            this.bits = OpenBitSet.grow(this.bits, numWords);
        }
    }

    public static long[] grow(long[] array, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array.length < minSize) {
            long[] newArray = new long[OpenBitSet.oversize(minSize, 8)];
            System.arraycopy(array, 0, newArray, 0, array.length);
            return newArray;
        }
        return array;
    }

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0) {
            return Integer.MAX_VALUE;
        }
        if (JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 2: {
                return newSize + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return newSize + 3 & 0x7FFFFFFC;
            }
        }
        return newSize;
    }

    public void ensureCapacity(long numBits) {
        this.ensureCapacityWords(OpenBitSet.bits2words(numBits));
    }

    public void trimTrailingZeros() {
        int idx;
        for (idx = this.wlen - 1; idx >= 0 && this.bits[idx] == 0L; --idx) {
        }
        this.wlen = idx + 1;
    }

    public static int bits2words(long numBits) {
        return (int)((numBits - 1L >>> 6) + 1L);
    }

    public boolean equals(Object o) {
        int i;
        OpenBitSet a;
        if (this == o) {
            return true;
        }
        if (!(o instanceof OpenBitSet)) {
            return false;
        }
        OpenBitSet b = (OpenBitSet)o;
        if (b.wlen > this.wlen) {
            a = b;
            b = this;
        } else {
            a = this;
        }
        for (i = a.wlen - 1; i >= b.wlen; --i) {
            if (a.bits[i] == 0L) continue;
            return false;
        }
        for (i = b.wlen - 1; i >= 0; --i) {
            if (a.bits[i] == b.bits[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        long h2 = 0L;
        int i = this.bits.length;
        while (--i >= 0) {
            h2 ^= this.bits[i];
            h2 = h2 << 1 | h2 >>> 63;
        }
        return (int)(h2 >> 32 ^ h2) + -1737092556;
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder();
        int length = this.getBits().length;
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                s2.append(", ");
            }
            s2.append(this.getBits()[i]);
        }
        return s2.toString();
    }

    @Override
    public BitMask set(int index) {
        this.fastSet(index);
        return this;
    }

    @Override
    public BitMask setAll(BitMask mask) {
        if (mask instanceof OpenBitSet) {
            this.union((OpenBitSet)mask);
        } else {
            if (mask instanceof AllSetBitMask) {
                return AllSetBitMask.get();
            }
            if (mask instanceof AllSetButLastBitMask) {
                return this.isSet(0) ? AllSetBitMask.get() : AllSetButLastBitMask.get();
            }
            if (mask instanceof EmptyButLastBitMask) {
                return this.set(0);
            }
            if (mask instanceof LongBitMask) {
                this.bits[0] = this.bits[0] | ((LongBitMask)mask).asLong();
            }
        }
        return this;
    }

    @Override
    public BitMask reset(int index) {
        this.fastClear(index);
        return this;
    }

    @Override
    public BitMask resetAll(BitMask mask) {
        if (mask instanceof OpenBitSet) {
            this.remove((OpenBitSet)mask);
        } else if (mask instanceof AllSetBitMask) {
            for (int i = 0; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        } else if (mask instanceof AllSetButLastBitMask) {
            this.bits[0] = this.isSet(0) ? 1L : 0L;
            for (int i = 1; i < this.bits.length; ++i) {
                this.bits[i] = 0L;
            }
        } else {
            if (mask instanceof EmptyButLastBitMask) {
                return this.reset(0);
            }
            if (mask instanceof LongBitMask) {
                this.bits[0] = this.bits[0] & -1L - ((LongBitMask)mask).asLong();
            }
        }
        return this;
    }

    @Override
    public boolean isSet(int index) {
        return this.getBit(index) == 1;
    }

    @Override
    public boolean isAllSet() {
        for (int i = 0; i < this.bits.length; ++i) {
            if (this.bits[i] == -1L) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean intersects(BitMask mask) {
        if (mask.isAllSet()) {
            return !this.isEmpty();
        }
        if (mask instanceof AllSetButLastBitMask) {
            return this.nextSetBit(1) != -1;
        }
        if (mask instanceof EmptyBitMask) {
            return false;
        }
        if (mask instanceof EmptyButLastBitMask) {
            return this.isSet(0);
        }
        return mask instanceof OpenBitSet ? this.intersects((OpenBitSet)mask) : (this.bits[0] & ((LongBitMask)mask).asLong()) != 0L;
    }

    @Override
    public String getInstancingStatement() {
        StringBuilder sb = new StringBuilder("new " + OpenBitSet.class.getCanonicalName() + "(new long[] { ");
        sb.append(this.bits[0]).append("L");
        for (int i = 1; i < this.bits.length; ++i) {
            sb.append(", ");
            sb.append(this.bits[i]).append("L");
        }
        sb.append(" }, ").append(this.wlen).append(")");
        return sb.toString();
    }

    static {
        boolean is64Bit = false;
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field unsafeField = unsafeClass.getDeclaredField("theUnsafe");
            unsafeField.setAccessible(true);
            Object unsafe = unsafeField.get(null);
            int addressSize = ((Number)unsafeClass.getMethod("addressSize", new Class[0]).invoke(unsafe, new Object[0])).intValue();
            is64Bit = addressSize >= 8;
        }
        catch (Exception e) {
            String x = System.getProperty("sun.arch.data.model");
            is64Bit = x != null ? x.indexOf("64") != -1 : OS_ARCH != null && OS_ARCH.indexOf("64") != -1;
        }
        JRE_IS_64BIT = is64Bit;
        boolean v7 = true;
        try {
            Throwable.class.getMethod("getSuppressed", new Class[0]);
        }
        catch (NoSuchMethodException nsme) {
            v7 = false;
        }
        JRE_IS_MINIMUM_JAVA7 = v7;
        if (JRE_IS_MINIMUM_JAVA7) {
            boolean v8 = true;
            try {
                Collections.class.getMethod("emptySortedSet", new Class[0]);
            }
            catch (NoSuchMethodException nsme) {
                v8 = false;
            }
            JRE_IS_MINIMUM_JAVA8 = v8;
        } else {
            JRE_IS_MINIMUM_JAVA8 = false;
        }
    }

    public static final class BitUtil {
        private static final byte[] BYTE_COUNTS = new byte[]{0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8};
        private static final int[] BIT_LISTS = new int[]{0, 1, 2, 33, 3, 49, 50, 801, 4, 65, 66, 1057, 67, 1073, 1074, 17185, 5, 81, 82, 1313, 83, 1329, 1330, 21281, 84, 1345, 1346, 21537, 1347, 21553, 21554, 344865, 6, 97, 98, 1569, 99, 1585, 1586, 25377, 100, 1601, 1602, 25633, 1603, 25649, 25650, 410401, 101, 1617, 1618, 25889, 1619, 25905, 25906, 414497, 1620, 25921, 25922, 414753, 25923, 414769, 414770, 6636321, 7, 113, 114, 1825, 115, 1841, 1842, 29473, 116, 1857, 1858, 29729, 1859, 29745, 29746, 475937, 117, 1873, 1874, 29985, 1875, 30001, 30002, 480033, 1876, 30017, 30018, 480289, 30019, 480305, 480306, 7684897, 118, 1889, 1890, 30241, 1891, 30257, 30258, 484129, 1892, 30273, 30274, 484385, 30275, 484401, 484402, 7750433, 1893, 30289, 30290, 484641, 30291, 484657, 484658, 7754529, 30292, 484673, 484674, 7754785, 484675, 7754801, 7754802, 124076833, 8, 129, 130, 2081, 131, 2097, 2098, 33569, 132, 2113, 2114, 33825, 2115, 33841, 33842, 541473, 133, 2129, 2130, 34081, 2131, 34097, 34098, 545569, 2132, 34113, 34114, 545825, 34115, 545841, 545842, 8733473, 134, 2145, 2146, 34337, 2147, 34353, 34354, 549665, 2148, 34369, 34370, 549921, 34371, 549937, 549938, 8799009, 2149, 34385, 34386, 550177, 34387, 550193, 550194, 8803105, 34388, 550209, 550210, 8803361, 550211, 8803377, 8803378, 140854049, 135, 2161, 2162, 34593, 2163, 34609, 34610, 553761, 2164, 34625, 34626, 554017, 34627, 554033, 554034, 8864545, 2165, 34641, 34642, 554273, 34643, 554289, 554290, 8868641, 34644, 554305, 554306, 8868897, 554307, 8868913, 8868914, 141902625, 2166, 34657, 34658, 554529, 34659, 554545, 554546, 8872737, 34660, 554561, 554562, 8872993, 554563, 8873009, 8873010, 141968161, 34661, 554577, 554578, 8873249, 554579, 8873265, 8873266, 141972257, 554580, 8873281, 8873282, 141972513, 8873283, 141972529, 141972530, -2023406815};

        private BitUtil() {
        }

        public static int bitCount(byte b) {
            return BYTE_COUNTS[b & 0xFF];
        }

        public static int bitList(byte b) {
            return BIT_LISTS[b & 0xFF];
        }

        public static long pop_array(long[] arr, int wordOffset, int numWords) {
            long popCount = 0L;
            int end = wordOffset + numWords;
            for (int i = wordOffset; i < end; ++i) {
                popCount += (long)Long.bitCount(arr[i]);
            }
            return popCount;
        }

        public static long pop_intersect(long[] arr1, long[] arr2, int wordOffset, int numWords) {
            long popCount = 0L;
            int end = wordOffset + numWords;
            for (int i = wordOffset; i < end; ++i) {
                popCount += (long)Long.bitCount(arr1[i] & arr2[i]);
            }
            return popCount;
        }

        public static long pop_union(long[] arr1, long[] arr2, int wordOffset, int numWords) {
            long popCount = 0L;
            int end = wordOffset + numWords;
            for (int i = wordOffset; i < end; ++i) {
                popCount += (long)Long.bitCount(arr1[i] | arr2[i]);
            }
            return popCount;
        }

        public static long pop_andnot(long[] arr1, long[] arr2, int wordOffset, int numWords) {
            long popCount = 0L;
            int end = wordOffset + numWords;
            for (int i = wordOffset; i < end; ++i) {
                popCount += (long)Long.bitCount(arr1[i] & (arr2[i] ^ 0xFFFFFFFFFFFFFFFFL));
            }
            return popCount;
        }

        public static long pop_xor(long[] arr1, long[] arr2, int wordOffset, int numWords) {
            long popCount = 0L;
            int end = wordOffset + numWords;
            for (int i = wordOffset; i < end; ++i) {
                popCount += (long)Long.bitCount(arr1[i] ^ arr2[i]);
            }
            return popCount;
        }

        public static int nextHighestPowerOfTwo(int v) {
            --v;
            v |= v >> 1;
            v |= v >> 2;
            v |= v >> 4;
            v |= v >> 8;
            v |= v >> 16;
            return ++v;
        }

        public static long nextHighestPowerOfTwo(long v) {
            --v;
            v |= v >> 1;
            v |= v >> 2;
            v |= v >> 4;
            v |= v >> 8;
            v |= v >> 16;
            v |= v >> 32;
            return ++v;
        }
    }
}

