/*
 * Decompiled with CFR 0.152.
 */
package org.drools.dynamic;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.Vector;
import org.drools.reflective.ResourceProvider;
import org.drools.reflective.classloader.ProjectClassLoader;
import org.drools.reflective.util.ClassUtils;

public class DynamicProjectClassLoader
extends ProjectClassLoader {
    private static boolean isIBM_JVM = System.getProperty("java.vendor").toLowerCase().contains("ibm");

    protected DynamicProjectClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
        super(parent, resourceProvider);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    protected boolean isStoreFirst(String name) {
        return DynamicProjectClassLoader.isEnableStoreFirst() && this.generatedClassNames.contains(name);
    }

    public static DynamicProjectClassLoader create(ClassLoader parent, ResourceProvider resourceProvider) {
        return isIBM_JVM ? new IBMDynamicClassLoader(parent, resourceProvider) : new DynamicProjectClassLoader(parent, resourceProvider);
    }

    @Override
    public ProjectClassLoader.InternalTypesClassLoader makeClassLoader() {
        return AccessController.doPrivileged(() -> ClassUtils.isAndroid() ? (ProjectClassLoader.InternalTypesClassLoader)ClassUtils.instantiateObject("org.drools.android.DexInternalTypesClassLoader", null, this) : new DefaultInternalTypesClassLoader(this));
    }

    private static class DefaultInternalTypesClassLoader
    extends ClassLoader
    implements ProjectClassLoader.InternalTypesClassLoader {
        private final ProjectClassLoader projectClassLoader;

        private DefaultInternalTypesClassLoader(ProjectClassLoader projectClassLoader) {
            super(projectClassLoader.getParent());
            this.projectClassLoader = projectClassLoader;
        }

        @Override
        public Class<?> defineClass(String name, byte[] bytecode) {
            String pkgName;
            int lastDot = name.lastIndexOf(46);
            if (lastDot > 0 && this.getPackage(pkgName = name.substring(0, lastDot)) == null) {
                this.definePackage(pkgName, "", "", "", "", "", "", null);
            }
            return this.defineClass(name, bytecode, 0, bytecode.length);
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            if (this.isStoreFirst(name)) {
                Class<?> clazz = this.findLoadedClass(name);
                if (clazz != null) {
                    return clazz;
                }
                return this.projectClassLoader.tryDefineType(name, null);
            }
            try {
                return this.loadType(name, resolve);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    return this.projectClassLoader.internalLoadClass(name, resolve);
                }
                catch (ClassNotFoundException cnfe2) {
                    return this.projectClassLoader.tryDefineType(name, cnfe);
                }
            }
        }

        private boolean isStoreFirst(String name) {
            return ProjectClassLoader.isEnableStoreFirst() && this.projectClassLoader.getGeneratedClassNames().contains(name);
        }

        @Override
        public Class<?> loadType(String name, boolean resolve) throws ClassNotFoundException {
            return super.loadClass(name, resolve);
        }

        @Override
        public Class<?> findLoadedClassWithoutParent(String name) {
            return this.findLoadedClass(name);
        }

        @Override
        public URL getResource(String name) {
            return this.projectClassLoader.getResource(name);
        }

        @Override
        public InputStream getResourceAsStream(String name) {
            return this.projectClassLoader.getResourceAsStream(name);
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            return this.projectClassLoader.getResources(name);
        }

        static {
            DefaultInternalTypesClassLoader.registerAsParallelCapable();
        }
    }

    public static class IBMDynamicClassLoader
    extends DynamicProjectClassLoader {
        private final boolean parentImplementsFindResources;
        private static final Enumeration<URL> EMPTY_RESOURCE_ENUM = new Vector().elements();

        private IBMDynamicClassLoader(ClassLoader parent, ResourceProvider resourceProvider) {
            super(parent, resourceProvider);
            Method m4 = null;
            try {
                m4 = parent.getClass().getMethod("findResources", String.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            this.parentImplementsFindResources = m4 != null && m4.getDeclaringClass() == parent.getClass();
        }

        @Override
        protected Enumeration<URL> findResources(String name) throws IOException {
            return this.parentImplementsFindResources ? EMPTY_RESOURCE_ENUM : this.getParent().getResources(name);
        }
    }
}

