/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.jaxb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlType;
import org.kie.internal.jaxb.StringKeyStringValueEntry;

@XmlType
@XmlAccessorType(value=XmlAccessType.FIELD)
public class StringKeyStringValueMap
implements Map<String, String> {
    @XmlElement(name="entry")
    public List<StringKeyStringValueEntry> entries = new ArrayList<StringKeyStringValueEntry>();

    public void addEntry(StringKeyStringValueEntry newEntry) {
        this.entries.add(newEntry);
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        for (StringKeyStringValueEntry entry : this.entries) {
            if (!key.equals(entry.getKey())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        for (StringKeyStringValueEntry entry : this.entries) {
            String entryVal = entry.getValue();
            if (!value.equals(entryVal)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String get(Object key) {
        if (key == null) {
            return null;
        }
        for (StringKeyStringValueEntry entry : this.entries) {
            if (key == null || !key.equals(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public String put(String key, String value) {
        String oldVal = this.get(key);
        StringKeyStringValueEntry newEntry = new StringKeyStringValueEntry(key, value);
        this.entries.add(newEntry);
        return oldVal;
    }

    @Override
    public String remove(Object key) {
        Iterator<StringKeyStringValueEntry> iter = this.entries.iterator();
        while (iter.hasNext()) {
            StringKeyStringValueEntry entry = iter.next();
            String entryKey = entry.getKey();
            if (!key.equals(entryKey)) continue;
            iter.remove();
            return entry.getValue();
        }
        return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m4) {
        for (Map.Entry<? extends String, ? extends String> entry : m4.entrySet()) {
            StringKeyStringValueEntry newEntry = new StringKeyStringValueEntry(entry.getKey(), entry.getValue());
            this.entries.add(newEntry);
        }
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (StringKeyStringValueEntry entry : this.entries) {
            keySet.add(entry.getKey());
        }
        return keySet;
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> values = new ArrayList<String>();
        for (StringKeyStringValueEntry entry : this.entries) {
            values.add(entry.getValue());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> entrySet = new HashSet<Map.Entry<String, String>>();
        for (StringKeyStringValueEntry entry : this.entries) {
            String newVal = entry.getValue();
            String key = entry.getKey();
            EntryImpl newEntry = new EntryImpl(key, newVal);
            entrySet.add(newEntry);
        }
        return entrySet;
    }

    private class EntryImpl
    implements Map.Entry<String, String> {
        private final String key;
        private String val;

        public EntryImpl(String key, String val) {
            this.key = key;
            this.val = val;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.val;
        }

        @Override
        public String setValue(String value) {
            String oldVal = this.val;
            this.val = value;
            return oldVal;
        }
    }
}

