/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendable;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import org.kie.api.definition.rule.Rule;
import org.kie.api.runtime.rule.RuleContext;
import org.optaplanner.core.api.domain.constraintweight.ConstraintConfiguration;
import org.optaplanner.core.api.domain.constraintweight.ConstraintWeight;
import org.optaplanner.core.api.score.buildin.bendable.BendableScore;
import org.optaplanner.core.api.score.holder.AbstractScoreHolder;

public class BendableScoreHolder
extends AbstractScoreHolder<BendableScore> {
    protected final Map<Rule, BiConsumer<RuleContext, Integer>> matchExecutorByNumberMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, Integer>>();
    protected final Map<Rule, BiConsumer<RuleContext, BendableScore>> matchExecutorByScoreMap = new LinkedHashMap<Rule, BiConsumer<RuleContext, BendableScore>>();
    private int[] hardScores;
    private int[] softScores;

    public BendableScoreHolder(boolean constraintMatchEnabled, int hardLevelsSize, int softLevelsSize) {
        super(constraintMatchEnabled, BendableScore.zero(hardLevelsSize, softLevelsSize));
        this.hardScores = new int[hardLevelsSize];
        this.softScores = new int[softLevelsSize];
    }

    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public int getHardScore(int hardLevel) {
        return this.hardScores[hardLevel];
    }

    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public int getSoftScore(int softLevel) {
        return this.softScores[softLevel];
    }

    @Override
    public void configureConstraintWeight(Rule rule, BendableScore constraintWeight) {
        BiConsumer<RuleContext, Integer> matchExecutor;
        super.configureConstraintWeight(rule, constraintWeight);
        if (constraintWeight.equals(BendableScore.zero(this.hardScores.length, this.softScores.length))) {
            matchExecutor = (kcontext, matchWeight) -> {};
        } else {
            Integer singleLevel = null;
            Integer singleLevelWeight = null;
            for (int i = 0; i < constraintWeight.getLevelsSize(); ++i) {
                int levelWeight = constraintWeight.getHardOrSoftScore(i);
                if (levelWeight == 0) continue;
                if (singleLevel != null) {
                    singleLevel = null;
                    singleLevelWeight = null;
                    break;
                }
                singleLevel = i;
                singleLevelWeight = levelWeight;
            }
            if (singleLevel != null) {
                int level;
                int levelWeight = singleLevelWeight;
                if (singleLevel < constraintWeight.getHardLevelsSize()) {
                    level = singleLevel;
                    matchExecutor = (kcontext, matchWeight) -> this.addHardConstraintMatch((RuleContext)kcontext, level, levelWeight * matchWeight);
                } else {
                    level = singleLevel - constraintWeight.getHardLevelsSize();
                    matchExecutor = (kcontext, matchWeight) -> this.addSoftConstraintMatch((RuleContext)kcontext, level, levelWeight * matchWeight);
                }
            } else {
                matchExecutor = (kcontext, matchWeight) -> {
                    int i;
                    int[] hardWeights = new int[this.hardScores.length];
                    int[] softWeights = new int[this.softScores.length];
                    for (i = 0; i < hardWeights.length; ++i) {
                        hardWeights[i] = constraintWeight.getHardScore(i) * matchWeight;
                    }
                    for (i = 0; i < softWeights.length; ++i) {
                        softWeights[i] = constraintWeight.getSoftScore(i) * matchWeight;
                    }
                    this.addMultiConstraintMatch((RuleContext)kcontext, hardWeights, softWeights);
                };
            }
        }
        this.matchExecutorByNumberMap.put(rule, matchExecutor);
        this.matchExecutorByScoreMap.put(rule, (kcontext, weightMultiplier) -> {
            int i;
            int[] hardWeights = new int[this.hardScores.length];
            int[] softWeights = new int[this.softScores.length];
            for (i = 0; i < hardWeights.length; ++i) {
                hardWeights[i] = constraintWeight.getHardScore(i) * weightMultiplier.getHardScore(i);
            }
            for (i = 0; i < softWeights.length; ++i) {
                softWeights[i] = constraintWeight.getSoftScore(i) * weightMultiplier.getSoftScore(i);
            }
            this.addMultiConstraintMatch((RuleContext)kcontext, hardWeights, softWeights);
        });
    }

    public void penalize(RuleContext kcontext) {
        this.reward(kcontext, -1);
    }

    public void penalize(RuleContext kcontext, int weightMultiplier) {
        this.reward(kcontext, -weightMultiplier);
    }

    public void penalize(RuleContext kcontext, int[] hardWeightsMultiplier, int[] softWeightsMultiplier) {
        int i;
        int[] negatedHardWeightsMultiplier = new int[this.hardScores.length];
        int[] negatedSoftWeightsMultiplier = new int[this.softScores.length];
        for (i = 0; i < negatedHardWeightsMultiplier.length; ++i) {
            negatedHardWeightsMultiplier[i] = -hardWeightsMultiplier[i];
        }
        for (i = 0; i < negatedSoftWeightsMultiplier.length; ++i) {
            negatedSoftWeightsMultiplier[i] = -softWeightsMultiplier[i];
        }
        this.reward(kcontext, negatedHardWeightsMultiplier, negatedSoftWeightsMultiplier);
    }

    public void reward(RuleContext kcontext) {
        this.reward(kcontext, 1);
    }

    public void reward(RuleContext kcontext, int weightMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, Integer> matchExecutor = this.matchExecutorByNumberMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, weightMultiplier);
    }

    public void reward(RuleContext kcontext, int[] hardWeightsMultiplier, int[] softWeightsMultiplier) {
        Rule rule = kcontext.getRule();
        BiConsumer<RuleContext, BendableScore> matchExecutor = this.matchExecutorByScoreMap.get(rule);
        if (matchExecutor == null) {
            throw new IllegalStateException("The DRL rule (" + rule.getPackageName() + ":" + rule.getName() + ") does not match a @" + ConstraintWeight.class.getSimpleName() + " on the @" + ConstraintConfiguration.class.getSimpleName() + " annotated class.");
        }
        matchExecutor.accept(kcontext, BendableScore.of(hardWeightsMultiplier, softWeightsMultiplier));
    }

    public void addHardConstraintMatch(RuleContext kcontext, int hardLevel, int weight) {
        int n = hardLevel;
        this.hardScores[n] = this.hardScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = hardLevel;
            this.hardScores[n] = this.hardScores[n] - weight;
        }, () -> {
            int[] newHardScores = new int[this.hardScores.length];
            int[] newSoftScores = new int[this.softScores.length];
            newHardScores[hardLevel] = weight;
            return BendableScore.of(newHardScores, newSoftScores);
        });
    }

    public void addSoftConstraintMatch(RuleContext kcontext, int softLevel, int weight) {
        int n = softLevel;
        this.softScores[n] = this.softScores[n] + weight;
        this.registerConstraintMatch(kcontext, () -> {
            int n = softLevel;
            this.softScores[n] = this.softScores[n] - weight;
        }, () -> {
            int[] newHardScores = new int[this.hardScores.length];
            int[] newSoftScores = new int[this.softScores.length];
            newSoftScores[softLevel] = weight;
            return BendableScore.of(newHardScores, newSoftScores);
        });
    }

    public void addMultiConstraintMatch(RuleContext kcontext, int[] hardWeights, int[] softWeights) {
        int i;
        if (this.hardScores.length != hardWeights.length) {
            throw new IllegalArgumentException("The hardScores length (" + this.hardScores.length + ") is different than the hardWeights length (" + hardWeights.length + ").");
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            int n = i;
            this.hardScores[n] = this.hardScores[n] + hardWeights[i];
        }
        if (this.softScores.length != softWeights.length) {
            throw new IllegalArgumentException("The softScores length (" + this.softScores.length + ") is different than the softWeights length (" + softWeights.length + ").");
        }
        for (i = 0; i < this.softScores.length; ++i) {
            int n = i;
            this.softScores[n] = this.softScores[n] + softWeights[i];
        }
        this.registerConstraintMatch(kcontext, () -> {
            int i;
            for (i = 0; i < this.hardScores.length; ++i) {
                int n = i;
                this.hardScores[n] = this.hardScores[n] - hardWeights[i];
            }
            for (i = 0; i < this.softScores.length; ++i) {
                int n = i;
                this.softScores[n] = this.softScores[n] - softWeights[i];
            }
        }, () -> BendableScore.of(hardWeights, softWeights));
    }

    @Override
    public BendableScore extractScore(int initScore) {
        return new BendableScore(initScore, Arrays.copyOf(this.hardScores, this.hardScores.length), Arrays.copyOf(this.softScores, this.softScores.length));
    }
}

