/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.api.score.buildin.bendablebigdecimal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import org.optaplanner.core.api.score.AbstractBendableScore;
import org.optaplanner.core.api.score.FeasibilityScore;
import org.optaplanner.core.api.score.Score;

public final class BendableBigDecimalScore
extends AbstractBendableScore<BendableBigDecimalScore>
implements FeasibilityScore<BendableBigDecimalScore> {
    private final BigDecimal[] hardScores;
    private final BigDecimal[] softScores;

    public static BendableBigDecimalScore parseScore(String scoreString) {
        String[][] scoreTokens = BendableBigDecimalScore.parseBendableScoreTokens(BendableBigDecimalScore.class, scoreString);
        int initScore = BendableBigDecimalScore.parseInitScore(BendableBigDecimalScore.class, scoreString, scoreTokens[0][0]);
        BigDecimal[] hardScores = new BigDecimal[scoreTokens[1].length];
        for (int i = 0; i < hardScores.length; ++i) {
            hardScores[i] = BendableBigDecimalScore.parseLevelAsBigDecimal(BendableBigDecimalScore.class, scoreString, scoreTokens[1][i]);
        }
        BigDecimal[] softScores = new BigDecimal[scoreTokens[2].length];
        for (int i = 0; i < softScores.length; ++i) {
            softScores[i] = BendableBigDecimalScore.parseLevelAsBigDecimal(BendableBigDecimalScore.class, scoreString, scoreTokens[2][i]);
        }
        return BendableBigDecimalScore.ofUninitialized(initScore, hardScores, softScores);
    }

    public static BendableBigDecimalScore ofUninitialized(int initScore, BigDecimal[] hardScores, BigDecimal[] softScores) {
        return new BendableBigDecimalScore(initScore, hardScores, softScores);
    }

    @Deprecated
    public static BendableBigDecimalScore valueOfUninitialized(int initScore, BigDecimal[] hardScores, BigDecimal[] softScores) {
        return new BendableBigDecimalScore(initScore, hardScores, softScores);
    }

    public static BendableBigDecimalScore of(BigDecimal[] hardScores, BigDecimal[] softScores) {
        return new BendableBigDecimalScore(0, hardScores, softScores);
    }

    @Deprecated
    public static BendableBigDecimalScore valueOf(BigDecimal[] hardScores, BigDecimal[] softScores) {
        return new BendableBigDecimalScore(0, hardScores, softScores);
    }

    public static BendableBigDecimalScore zero(int hardLevelsSize, int softLevelsSize) {
        Object[] hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(hardScores, BigDecimal.ZERO);
        Object[] softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(softScores, BigDecimal.ZERO);
        return new BendableBigDecimalScore(0, (BigDecimal[])hardScores, (BigDecimal[])softScores);
    }

    public static BendableBigDecimalScore ofHard(int hardLevelsSize, int softLevelsSize, int hardLevel, BigDecimal hardScore) {
        Object[] hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(hardScores, BigDecimal.ZERO);
        Object[] softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(softScores, BigDecimal.ZERO);
        hardScores[hardLevel] = hardScore;
        return new BendableBigDecimalScore(0, (BigDecimal[])hardScores, (BigDecimal[])softScores);
    }

    public static BendableBigDecimalScore ofSoft(int hardLevelsSize, int softLevelsSize, int softLevel, BigDecimal softScore) {
        Object[] hardScores = new BigDecimal[hardLevelsSize];
        Arrays.fill(hardScores, BigDecimal.ZERO);
        Object[] softScores = new BigDecimal[softLevelsSize];
        Arrays.fill(softScores, BigDecimal.ZERO);
        softScores[softLevel] = softScore;
        return new BendableBigDecimalScore(0, (BigDecimal[])hardScores, (BigDecimal[])softScores);
    }

    private BendableBigDecimalScore() {
        super(Integer.MIN_VALUE);
        this.hardScores = null;
        this.softScores = null;
    }

    protected BendableBigDecimalScore(int initScore, BigDecimal[] hardScores, BigDecimal[] softScores) {
        super(initScore);
        this.hardScores = hardScores;
        this.softScores = softScores;
    }

    public BigDecimal[] getHardScores() {
        return Arrays.copyOf(this.hardScores, this.hardScores.length);
    }

    public BigDecimal[] getSoftScores() {
        return Arrays.copyOf(this.softScores, this.softScores.length);
    }

    @Override
    public int getHardLevelsSize() {
        return this.hardScores.length;
    }

    public BigDecimal getHardScore(int index) {
        return this.hardScores[index];
    }

    @Override
    public int getSoftLevelsSize() {
        return this.softScores.length;
    }

    public BigDecimal getSoftScore(int index) {
        return this.softScores[index];
    }

    @Override
    public BendableBigDecimalScore toInitializedScore() {
        return this.initScore == 0 ? this : new BendableBigDecimalScore(0, this.hardScores, this.softScores);
    }

    @Override
    public BendableBigDecimalScore withInitScore(int newInitScore) {
        this.assertNoInitScore();
        return new BendableBigDecimalScore(newInitScore, this.hardScores, this.softScores);
    }

    @Override
    public int getLevelsSize() {
        return this.hardScores.length + this.softScores.length;
    }

    public BigDecimal getHardOrSoftScore(int index) {
        if (index < this.hardScores.length) {
            return this.hardScores[index];
        }
        return this.softScores[index - this.hardScores.length];
    }

    @Override
    public boolean isFeasible() {
        if (this.initScore < 0) {
            return false;
        }
        for (BigDecimal hardScore : this.hardScores) {
            if (hardScore.compareTo(BigDecimal.ZERO) >= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public BendableBigDecimalScore add(BendableBigDecimalScore augment) {
        int i;
        this.validateCompatible(augment);
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].add(augment.getHardScore(i));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].add(augment.getSoftScore(i));
        }
        return new BendableBigDecimalScore(this.initScore + augment.getInitScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore subtract(BendableBigDecimalScore subtrahend) {
        int i;
        this.validateCompatible(subtrahend);
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].subtract(subtrahend.getHardScore(i));
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].subtract(subtrahend.getSoftScore(i));
        }
        return new BendableBigDecimalScore(this.initScore - subtrahend.getInitScore(), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore multiply(double multiplicand) {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        BigDecimal bigDecimalMultiplicand = BigDecimal.valueOf(multiplicand);
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].multiply(bigDecimalMultiplicand).setScale(this.hardScores[i].scale(), RoundingMode.FLOOR);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].multiply(bigDecimalMultiplicand).setScale(this.softScores[i].scale(), RoundingMode.FLOOR);
        }
        return new BendableBigDecimalScore((int)Math.floor((double)this.initScore * multiplicand), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore divide(double divisor) {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        BigDecimal bigDecimalDivisor = BigDecimal.valueOf(divisor);
        for (i = 0; i < newHardScores.length; ++i) {
            BigDecimal hardScore = this.hardScores[i];
            newHardScores[i] = hardScore.divide(bigDecimalDivisor, hardScore.scale(), RoundingMode.FLOOR);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            BigDecimal softScore = this.softScores[i];
            newSoftScores[i] = softScore.divide(bigDecimalDivisor, softScore.scale(), RoundingMode.FLOOR);
        }
        return new BendableBigDecimalScore((int)Math.floor((double)this.initScore / divisor), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore power(double exponent) {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        BigDecimal actualExponent = BigDecimal.valueOf(exponent);
        for (i = 0; i < newHardScores.length; ++i) {
            BigDecimal hardScore = this.hardScores[i];
            newHardScores[i] = hardScore.pow(actualExponent.intValue()).setScale(hardScore.scale(), RoundingMode.FLOOR);
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            BigDecimal softScore = this.softScores[i];
            newSoftScores[i] = softScore.pow(actualExponent.intValue()).setScale(softScore.scale(), RoundingMode.FLOOR);
        }
        return new BendableBigDecimalScore((int)Math.floor(Math.pow(this.initScore, exponent)), newHardScores, newSoftScores);
    }

    @Override
    public BendableBigDecimalScore negate() {
        int i;
        BigDecimal[] newHardScores = new BigDecimal[this.hardScores.length];
        BigDecimal[] newSoftScores = new BigDecimal[this.softScores.length];
        for (i = 0; i < newHardScores.length; ++i) {
            newHardScores[i] = this.hardScores[i].negate();
        }
        for (i = 0; i < newSoftScores.length; ++i) {
            newSoftScores[i] = this.softScores[i].negate();
        }
        return new BendableBigDecimalScore(-this.initScore, newHardScores, newSoftScores);
    }

    @Override
    public Number[] toLevelNumbers() {
        int i;
        Number[] levelNumbers = new Number[this.hardScores.length + this.softScores.length];
        for (i = 0; i < this.hardScores.length; ++i) {
            levelNumbers[i] = this.hardScores[i];
        }
        for (i = 0; i < this.softScores.length; ++i) {
            levelNumbers[this.hardScores.length + i] = this.softScores[i];
        }
        return levelNumbers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof BendableBigDecimalScore) {
            int i;
            BendableBigDecimalScore other = (BendableBigDecimalScore)o;
            if (this.getHardLevelsSize() != other.getHardLevelsSize() || this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
                return false;
            }
            if (this.initScore != other.getInitScore()) {
                return false;
            }
            for (i = 0; i < this.hardScores.length; ++i) {
                if (this.hardScores[i].stripTrailingZeros().equals(other.getHardScore(i).stripTrailingZeros())) continue;
                return false;
            }
            for (i = 0; i < this.softScores.length; ++i) {
                if (this.softScores[i].stripTrailingZeros().equals(other.getSoftScore(i).stripTrailingZeros())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 629 + this.initScore;
        for (BigDecimal hardScore : this.hardScores) {
            hashCode = 37 * hashCode + hardScore.stripTrailingZeros().hashCode();
        }
        for (BigDecimal softScore : this.softScores) {
            hashCode = 37 * hashCode + softScore.stripTrailingZeros().hashCode();
        }
        return hashCode;
    }

    @Override
    public int compareTo(BendableBigDecimalScore other) {
        int i;
        this.validateCompatible(other);
        if (this.initScore != other.getInitScore()) {
            return this.initScore < other.getInitScore() ? -1 : 1;
        }
        for (i = 0; i < this.hardScores.length; ++i) {
            int hardScoreComparison = this.hardScores[i].compareTo(other.getHardScore(i));
            if (hardScoreComparison == 0) continue;
            return hardScoreComparison;
        }
        for (i = 0; i < this.softScores.length; ++i) {
            int softScoreComparison = this.softScores[i].compareTo(other.getSoftScore(i));
            if (softScoreComparison == 0) continue;
            return softScoreComparison;
        }
        return 0;
    }

    @Override
    public String toShortString() {
        return this.buildBendableShortString(n -> ((BigDecimal)n).compareTo(BigDecimal.ZERO) != 0);
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder((this.hardScores.length + this.softScores.length) * 4 + 13);
        s2.append(this.getInitPrefix());
        s2.append("[");
        boolean first = true;
        for (BigDecimal hardScore : this.hardScores) {
            if (first) {
                first = false;
            } else {
                s2.append("/");
            }
            s2.append(hardScore);
        }
        s2.append("]hard/[");
        first = true;
        for (BigDecimal softScore : this.softScores) {
            if (first) {
                first = false;
            } else {
                s2.append("/");
            }
            s2.append(softScore);
        }
        s2.append("]soft");
        return s2.toString();
    }

    public void validateCompatible(BendableBigDecimalScore other) {
        if (this.getHardLevelsSize() != other.getHardLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with hardScoreSize (" + this.getHardLevelsSize() + ") is not compatible with the other score (" + other + ") with hardScoreSize (" + other.getHardLevelsSize() + ").");
        }
        if (this.getSoftLevelsSize() != other.getSoftLevelsSize()) {
            throw new IllegalArgumentException("The score (" + this + ") with softScoreSize (" + this.getSoftLevelsSize() + ") is not compatible with the other score (" + other + ") with softScoreSize (" + other.getSoftLevelsSize() + ").");
        }
    }

    @Override
    public boolean isCompatibleArithmeticArgument(Score otherScore) {
        if (!(otherScore instanceof BendableBigDecimalScore)) {
            return false;
        }
        BendableBigDecimalScore otherBendableScore = (BendableBigDecimalScore)otherScore;
        return this.hardScores.length == otherBendableScore.hardScores.length && this.softScores.length == otherBendableScore.softScores.length;
    }
}

