/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.config.heuristic.selector.move.composite;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.ObjectUtils;
import org.optaplanner.core.config.heuristic.policy.HeuristicConfigPolicy;
import org.optaplanner.core.config.heuristic.selector.common.SelectionCacheType;
import org.optaplanner.core.config.heuristic.selector.common.SelectionOrder;
import org.optaplanner.core.config.heuristic.selector.move.MoveSelectorConfig;
import org.optaplanner.core.config.util.ConfigUtils;
import org.optaplanner.core.impl.heuristic.selector.move.MoveSelector;
import org.optaplanner.core.impl.heuristic.selector.move.composite.CartesianProductMoveSelector;

@XStreamAlias(value="cartesianProductMoveSelector")
public class CartesianProductMoveSelectorConfig
extends MoveSelectorConfig<CartesianProductMoveSelectorConfig> {
    @XStreamImplicit
    private List<MoveSelectorConfig> moveSelectorConfigList = null;
    private Boolean ignoreEmptyChildIterators = null;

    public CartesianProductMoveSelectorConfig() {
    }

    public CartesianProductMoveSelectorConfig(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    public List<MoveSelectorConfig> getMoveSelectorConfigList() {
        return this.moveSelectorConfigList;
    }

    public void setMoveSelectorConfigList(List<MoveSelectorConfig> moveSelectorConfigList) {
        this.moveSelectorConfigList = moveSelectorConfigList;
    }

    public Boolean getIgnoreEmptyChildIterators() {
        return this.ignoreEmptyChildIterators;
    }

    public void setIgnoreEmptyChildIterators(Boolean ignoreEmptyChildIterators) {
        this.ignoreEmptyChildIterators = ignoreEmptyChildIterators;
    }

    @Override
    public MoveSelector buildBaseMoveSelector(HeuristicConfigPolicy configPolicy, SelectionCacheType minimumCacheType, boolean randomSelection) {
        ArrayList<MoveSelector> moveSelectorList = new ArrayList<MoveSelector>(this.moveSelectorConfigList.size());
        for (MoveSelectorConfig moveSelectorConfig : this.moveSelectorConfigList) {
            moveSelectorList.add(moveSelectorConfig.buildMoveSelector(configPolicy, minimumCacheType, SelectionOrder.fromRandomSelectionBoolean(randomSelection)));
        }
        boolean ignoreEmptyChildIterators_ = ObjectUtils.defaultIfNull(this.ignoreEmptyChildIterators, true);
        return new CartesianProductMoveSelector(moveSelectorList, ignoreEmptyChildIterators_, randomSelection);
    }

    @Override
    public void extractLeafMoveSelectorConfigsIntoList(List<MoveSelectorConfig> leafMoveSelectorConfigList) {
        for (MoveSelectorConfig moveSelectorConfig : this.moveSelectorConfigList) {
            moveSelectorConfig.extractLeafMoveSelectorConfigsIntoList(leafMoveSelectorConfigList);
        }
    }

    @Override
    public void inherit(CartesianProductMoveSelectorConfig inheritedConfig) {
        super.inherit(inheritedConfig);
        this.moveSelectorConfigList = ConfigUtils.inheritMergeableListConfig(this.moveSelectorConfigList, inheritedConfig.getMoveSelectorConfigList());
        this.ignoreEmptyChildIterators = ConfigUtils.inheritOverwritableProperty(this.ignoreEmptyChildIterators, inheritedConfig.getIgnoreEmptyChildIterators());
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.moveSelectorConfigList + ")";
    }
}

