/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.domain.lookup;

import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.core.api.domain.lookup.LookUpStrategyType;
import org.optaplanner.core.api.domain.lookup.PlanningId;
import org.optaplanner.core.api.domain.solution.PlanningSolution;
import org.optaplanner.core.impl.domain.common.accessor.MemberAccessor;
import org.optaplanner.core.impl.domain.lookup.LookUpStrategy;

public class PlanningIdLookUpStrategy
implements LookUpStrategy {
    private MemberAccessor planningIdMemberAccessor;

    public PlanningIdLookUpStrategy(MemberAccessor planningIdMemberAccessor) {
        this.planningIdMemberAccessor = planningIdMemberAccessor;
    }

    @Override
    public void addWorkingObject(Map<Object, Object> idToWorkingObjectMap, Object workingObject) {
        Object planningId = this.extractPlanningId(workingObject);
        Object oldAddedObject = idToWorkingObjectMap.put(planningId, workingObject);
        if (oldAddedObject != null) {
            throw new IllegalStateException("The workingObjects (" + oldAddedObject + ", " + workingObject + ") have the same planningId (" + planningId + "). Working objects must be unique.");
        }
    }

    @Override
    public void removeWorkingObject(Map<Object, Object> idToWorkingObjectMap, Object workingObject) {
        Object planningId = this.extractPlanningId(workingObject);
        Object removedObject = idToWorkingObjectMap.remove(planningId);
        if (workingObject != removedObject) {
            throw new IllegalStateException("The workingObject (" + workingObject + ") differs from the removedObject (" + removedObject + ") for planningId (" + planningId + ").");
        }
    }

    @Override
    public <E> E lookUpWorkingObject(Map<Object, Object> idToWorkingObjectMap, E externalObject) {
        Object planningId = this.extractPlanningId(externalObject);
        return (E)idToWorkingObjectMap.get(planningId);
    }

    protected Object extractPlanningId(Object externalObject) {
        Object planningId = this.planningIdMemberAccessor.executeGetter(externalObject);
        if (planningId == null) {
            throw new IllegalArgumentException("The planningId (" + planningId + ") of the member (" + this.planningIdMemberAccessor + ") of the class (" + externalObject.getClass() + ") on externalObject (" + externalObject + ") must not be null.\nMaybe initialize the planningId of the class (" + externalObject.getClass().getSimpleName() + ") instance (" + externalObject + ") before solving.\nMaybe remove the " + PlanningId.class.getSimpleName() + " annotation or change the " + PlanningSolution.class.getSimpleName() + " annotation's " + LookUpStrategyType.class.getSimpleName() + ".");
        }
        return Pair.of(externalObject.getClass(), planningId);
    }
}

