/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.common.nearby;

import java.util.Random;
import org.optaplanner.core.impl.heuristic.selector.common.nearby.NearbyRandom;

public class ParabolicDistributionNearbyRandom
implements NearbyRandom {
    protected final int sizeMaximum;

    public ParabolicDistributionNearbyRandom(int sizeMaximum) {
        this.sizeMaximum = sizeMaximum;
        if (sizeMaximum < 1) {
            throw new IllegalArgumentException("The maximum (" + sizeMaximum + ") must be at least 1.");
        }
    }

    @Override
    public int nextInt(Random random, int nearbySize) {
        double p;
        int m4 = this.sizeMaximum <= nearbySize ? this.sizeMaximum : nearbySize;
        double x = (double)m4 * (1.0 - Math.pow(1.0 - (p = random.nextDouble()), 0.3333333333333333));
        int next = (int)x;
        if (next >= m4) {
            next = m4 - 1;
        }
        return next;
    }

    @Override
    public int getOverallSizeMaximum() {
        return this.sizeMaximum;
    }
}

