/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.api.domain.valuerange.ValueRange;
import org.optaplanner.core.impl.domain.valuerange.descriptor.ValueRangeDescriptor;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class PillarSwapMove<Solution_>
extends AbstractMove<Solution_> {
    protected final List<GenuineVariableDescriptor<Solution_>> variableDescriptorList;
    protected final List<Object> leftPillar;
    protected final List<Object> rightPillar;

    public PillarSwapMove(List<GenuineVariableDescriptor<Solution_>> variableDescriptorList, List<Object> leftPillar, List<Object> rightPillar) {
        this.variableDescriptorList = variableDescriptorList;
        this.leftPillar = leftPillar;
        this.rightPillar = rightPillar;
    }

    public List<String> getVariableNameList() {
        ArrayList<String> variableNameList = new ArrayList<String>(this.variableDescriptorList.size());
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            variableNameList.add(variableDescriptor.getVariableName());
        }
        return variableNameList;
    }

    public List<Object> getLeftPillar() {
        return this.leftPillar;
    }

    public List<Object> getRightPillar() {
        return this.rightPillar;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        boolean movable = false;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            Object rightValue;
            Object leftValue = variableDescriptor.getValue(this.leftPillar.get(0));
            if (Objects.equals(leftValue, rightValue = variableDescriptor.getValue(this.rightPillar.get(0)))) continue;
            movable = true;
            if (variableDescriptor.isValueRangeEntityIndependent()) continue;
            ValueRangeDescriptor<Solution_> valueRangeDescriptor = variableDescriptor.getValueRangeDescriptor();
            Solution_ workingSolution = scoreDirector.getWorkingSolution();
            for (Object rightEntity : this.rightPillar) {
                ValueRange<?> rightValueRange = valueRangeDescriptor.extractValueRange(workingSolution, rightEntity);
                if (rightValueRange.contains(leftValue)) continue;
                return false;
            }
            for (Object leftEntity : this.leftPillar) {
                ValueRange<?> leftValueRange = valueRangeDescriptor.extractValueRange(workingSolution, leftEntity);
                if (leftValueRange.contains(rightValue)) continue;
                return false;
            }
        }
        return movable;
    }

    @Override
    public PillarSwapMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        return new PillarSwapMove<Solution_>(this.variableDescriptorList, this.rightPillar, this.leftPillar);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            Object oldRightValue;
            Object oldLeftValue = variableDescriptor.getValue(this.leftPillar.get(0));
            if (Objects.equals(oldLeftValue, oldRightValue = variableDescriptor.getValue(this.rightPillar.get(0)))) continue;
            for (Object leftEntity : this.leftPillar) {
                scoreDirector.beforeVariableChanged(variableDescriptor, leftEntity);
                variableDescriptor.setValue(leftEntity, oldRightValue);
                scoreDirector.afterVariableChanged(variableDescriptor, leftEntity);
            }
            for (Object rightEntity : this.rightPillar) {
                scoreDirector.beforeVariableChanged(variableDescriptor, rightEntity);
                variableDescriptor.setValue(rightEntity, oldLeftValue);
                scoreDirector.afterVariableChanged(variableDescriptor, rightEntity);
            }
        }
    }

    @Override
    public PillarSwapMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new PillarSwapMove<Solution_>(this.variableDescriptorList, PillarSwapMove.rebaseList(this.leftPillar, destinationScoreDirector), PillarSwapMove.rebaseList(this.rightPillar, destinationScoreDirector));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        StringBuilder moveTypeDescription = new StringBuilder(20 * (this.variableDescriptorList.size() + 1));
        moveTypeDescription.append(this.getClass().getSimpleName()).append("(");
        String delimiter = "";
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            moveTypeDescription.append(delimiter).append(variableDescriptor.getSimpleEntityAndVariableName());
            delimiter = ", ";
        }
        moveTypeDescription.append(")");
        return moveTypeDescription.toString();
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        ArrayList<Object> entities = new ArrayList<Object>(this.leftPillar.size() + this.rightPillar.size());
        entities.addAll(this.leftPillar);
        entities.addAll(this.rightPillar);
        return entities;
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        ArrayList<Object> values = new ArrayList<Object>(this.variableDescriptorList.size() * 2);
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            values.add(variableDescriptor.getValue(this.leftPillar.get(0)));
            values.add(variableDescriptor.getValue(this.rightPillar.get(0)));
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof PillarSwapMove) {
            PillarSwapMove other = (PillarSwapMove)o;
            return new EqualsBuilder().append(this.variableDescriptorList, other.variableDescriptorList).append(this.leftPillar, other.leftPillar).append(this.rightPillar, other.rightPillar).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.variableDescriptorList).append(this.leftPillar).append(this.rightPillar).toHashCode();
    }

    public String toString() {
        StringBuilder s2 = new StringBuilder(this.variableDescriptorList.size() * 16);
        s2.append(this.leftPillar).append(" {");
        this.appendVariablesToString(s2, this.leftPillar);
        s2.append("} <-> ");
        s2.append(this.rightPillar).append(" {");
        this.appendVariablesToString(s2, this.rightPillar);
        s2.append("}");
        return s2.toString();
    }

    protected void appendVariablesToString(StringBuilder s2, List<Object> pillar) {
        boolean first = true;
        for (GenuineVariableDescriptor<Solution_> variableDescriptor : this.variableDescriptorList) {
            if (!first) {
                s2.append(", ");
            }
            s2.append(variableDescriptor.getValue(pillar.get(0)));
            first = false;
        }
    }
}

