/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.heuristic.selector.move.generic.chained;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.optaplanner.core.impl.domain.variable.descriptor.GenuineVariableDescriptor;
import org.optaplanner.core.impl.domain.variable.inverserelation.SingletonInverseVariableSupply;
import org.optaplanner.core.impl.heuristic.move.AbstractMove;
import org.optaplanner.core.impl.heuristic.selector.value.chained.SubChain;
import org.optaplanner.core.impl.score.director.ScoreDirector;

public class SubChainReversingChangeMove<Solution_>
extends AbstractMove<Solution_> {
    protected final SubChain subChain;
    protected final GenuineVariableDescriptor<Solution_> variableDescriptor;
    protected final Object toPlanningValue;
    protected final Object oldTrailingLastEntity;
    protected final Object newTrailingEntity;

    public SubChainReversingChangeMove(SubChain subChain, GenuineVariableDescriptor<Solution_> variableDescriptor, SingletonInverseVariableSupply inverseVariableSupply, Object toPlanningValue) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
        this.oldTrailingLastEntity = inverseVariableSupply.getInverseSingleton(subChain.getLastEntity());
        this.newTrailingEntity = toPlanningValue == null ? null : inverseVariableSupply.getInverseSingleton(toPlanningValue);
    }

    public SubChainReversingChangeMove(SubChain subChain, GenuineVariableDescriptor<Solution_> variableDescriptor, Object toPlanningValue, Object oldTrailingLastEntity, Object newTrailingEntity) {
        this.subChain = subChain;
        this.variableDescriptor = variableDescriptor;
        this.toPlanningValue = toPlanningValue;
        this.oldTrailingLastEntity = oldTrailingLastEntity;
        this.newTrailingEntity = newTrailingEntity;
    }

    public String getVariableName() {
        return this.variableDescriptor.getVariableName();
    }

    public SubChain getSubChain() {
        return this.subChain;
    }

    public Object getToPlanningValue() {
        return this.toPlanningValue;
    }

    @Override
    public boolean isMoveDoable(ScoreDirector<Solution_> scoreDirector) {
        if (this.subChain.getEntityList().contains(this.toPlanningValue)) {
            return false;
        }
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return !Objects.equals(oldFirstValue, this.toPlanningValue);
    }

    @Override
    public SubChainReversingChangeMove<Solution_> createUndoMove(ScoreDirector<Solution_> scoreDirector) {
        boolean unmovedReverse;
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        boolean bl = unmovedReverse = this.toPlanningValue == oldFirstValue;
        if (!unmovedReverse) {
            return new SubChainReversingChangeMove<Solution_>(this.subChain.reverse(), this.variableDescriptor, oldFirstValue, this.newTrailingEntity, this.oldTrailingLastEntity);
        }
        return new SubChainReversingChangeMove<Solution_>(this.subChain.reverse(), this.variableDescriptor, oldFirstValue, this.oldTrailingLastEntity, this.newTrailingEntity);
    }

    @Override
    protected void doMoveOnGenuineVariables(ScoreDirector<Solution_> scoreDirector) {
        boolean unmovedReverse;
        Object firstEntity = this.subChain.getFirstEntity();
        Object lastEntity = this.subChain.getLastEntity();
        Object oldFirstValue = this.variableDescriptor.getValue(firstEntity);
        boolean bl = unmovedReverse = this.toPlanningValue == oldFirstValue;
        if (!unmovedReverse && this.oldTrailingLastEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, this.oldTrailingLastEntity, oldFirstValue);
        }
        Object lastEntityValue = this.variableDescriptor.getValue(lastEntity);
        scoreDirector.changeVariableFacade(this.variableDescriptor, lastEntity, this.toPlanningValue);
        this.reverseChain(scoreDirector, lastEntity, lastEntityValue, firstEntity);
        if (!unmovedReverse) {
            if (this.newTrailingEntity != null) {
                scoreDirector.changeVariableFacade(this.variableDescriptor, this.newTrailingEntity, firstEntity);
            }
        } else if (this.oldTrailingLastEntity != null) {
            scoreDirector.changeVariableFacade(this.variableDescriptor, this.oldTrailingLastEntity, firstEntity);
        }
    }

    private void reverseChain(ScoreDirector<Solution_> scoreDirector, Object entity, Object previous, Object toEntity) {
        while (entity != toEntity) {
            Object value = this.variableDescriptor.getValue(previous);
            scoreDirector.changeVariableFacade(this.variableDescriptor, previous, entity);
            entity = previous;
            previous = value;
        }
    }

    @Override
    public SubChainReversingChangeMove<Solution_> rebase(ScoreDirector<Solution_> destinationScoreDirector) {
        return new SubChainReversingChangeMove<Solution_>(this.subChain.rebase(destinationScoreDirector), this.variableDescriptor, destinationScoreDirector.lookUpWorkingObject(this.toPlanningValue), destinationScoreDirector.lookUpWorkingObject(this.oldTrailingLastEntity), destinationScoreDirector.lookUpWorkingObject(this.newTrailingEntity));
    }

    @Override
    public String getSimpleMoveTypeDescription() {
        return this.getClass().getSimpleName() + "(" + this.variableDescriptor.getSimpleEntityAndVariableName() + ")";
    }

    @Override
    public Collection<? extends Object> getPlanningEntities() {
        return this.subChain.getEntityList();
    }

    @Override
    public Collection<? extends Object> getPlanningValues() {
        return Collections.singletonList(this.toPlanningValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SubChainReversingChangeMove) {
            SubChainReversingChangeMove other = (SubChainReversingChangeMove)o;
            return new EqualsBuilder().append(this.subChain, other.subChain).append(this.variableDescriptor.getVariableName(), other.variableDescriptor.getVariableName()).append(this.toPlanningValue, other.toPlanningValue).isEquals();
        }
        return false;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.subChain).append(this.variableDescriptor.getVariableName()).append(this.toPlanningValue).toHashCode();
    }

    public String toString() {
        Object oldFirstValue = this.variableDescriptor.getValue(this.subChain.getFirstEntity());
        return this.subChain.toDottedString() + " {" + oldFirstValue + " -reversing-> " + this.toPlanningValue + "}";
    }
}

