/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.termination;

import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.Queue;
import org.apache.commons.lang3.tuple.Pair;
import org.optaplanner.core.api.score.Score;
import org.optaplanner.core.impl.phase.scope.AbstractPhaseScope;
import org.optaplanner.core.impl.phase.scope.AbstractStepScope;
import org.optaplanner.core.impl.solver.ChildThreadType;
import org.optaplanner.core.impl.solver.scope.DefaultSolverScope;
import org.optaplanner.core.impl.solver.termination.AbstractTermination;

public class UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination
extends AbstractTermination {
    private final long unimprovedTimeMillisSpentLimit;
    private final Score unimprovedScoreDifferenceThreshold;
    private Queue<Pair<Long, Score>> bestScoreImprovementHistoryQueue;
    private long solverSafeTimeMillis = -1L;
    private long phaseSafeTimeMillis = -1L;

    public UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination(long unimprovedTimeMillisSpentLimit, Score unimprovedScoreDifferenceThreshold) {
        this.unimprovedTimeMillisSpentLimit = unimprovedTimeMillisSpentLimit;
        this.unimprovedScoreDifferenceThreshold = unimprovedScoreDifferenceThreshold;
        if (unimprovedTimeMillisSpentLimit <= 0L) {
            throw new IllegalArgumentException("The unimprovedTimeMillisSpentLimit (" + unimprovedTimeMillisSpentLimit + ") cannot be negative.");
        }
    }

    public long getUnimprovedTimeMillisSpentLimit() {
        return this.unimprovedTimeMillisSpentLimit;
    }

    public Score getUnimprovedScoreDifferenceThreshold() {
        return this.unimprovedScoreDifferenceThreshold;
    }

    @Override
    public void solvingStarted(DefaultSolverScope solverScope) {
        this.bestScoreImprovementHistoryQueue = new ArrayDeque<Pair<Long, Score>>();
        this.solverSafeTimeMillis = solverScope.getBestSolutionTimeMillis() + this.unimprovedTimeMillisSpentLimit;
    }

    @Override
    public void solvingEnded(DefaultSolverScope solverScope) {
        this.bestScoreImprovementHistoryQueue = null;
        this.solverSafeTimeMillis = -1L;
    }

    public void phaseStarted(AbstractPhaseScope phaseScope) {
        this.phaseSafeTimeMillis = phaseScope.getStartingSystemTimeMillis() + this.unimprovedTimeMillisSpentLimit;
    }

    public void phaseEnded(AbstractPhaseScope phaseScope) {
        this.phaseSafeTimeMillis = -1L;
    }

    public void stepEnded(AbstractStepScope stepScope) {
        if (stepScope.getBestScoreImproved().booleanValue()) {
            Pair bestScoreImprovement;
            Score scoreDifference;
            DefaultSolverScope solverScope = stepScope.getPhaseScope().getSolverScope();
            long bestSolutionTimeMillis = solverScope.getBestSolutionTimeMillis();
            Score bestScore = solverScope.getBestScore();
            Iterator it = this.bestScoreImprovementHistoryQueue.iterator();
            while (it.hasNext() && (scoreDifference = bestScore.subtract((Score)(bestScoreImprovement = (Pair)it.next()).getValue())).compareTo(this.unimprovedScoreDifferenceThreshold) >= 0) {
                long safeTimeMillis;
                it.remove();
                this.solverSafeTimeMillis = safeTimeMillis = (Long)bestScoreImprovement.getKey() + this.unimprovedTimeMillisSpentLimit;
                this.phaseSafeTimeMillis = safeTimeMillis;
            }
            this.bestScoreImprovementHistoryQueue.add(Pair.of(bestSolutionTimeMillis, bestScore));
        }
    }

    @Override
    public boolean isSolverTerminated(DefaultSolverScope solverScope) {
        return this.isTerminated(this.solverSafeTimeMillis);
    }

    @Override
    public boolean isPhaseTerminated(AbstractPhaseScope phaseScope) {
        return this.isTerminated(this.phaseSafeTimeMillis);
    }

    protected boolean isTerminated(long safeTimeMillis) {
        long now = System.currentTimeMillis();
        return now > safeTimeMillis;
    }

    @Override
    public double calculateSolverTimeGradient(DefaultSolverScope solverScope) {
        return this.calculateTimeGradient(this.solverSafeTimeMillis);
    }

    @Override
    public double calculatePhaseTimeGradient(AbstractPhaseScope phaseScope) {
        return this.calculateTimeGradient(this.phaseSafeTimeMillis);
    }

    protected double calculateTimeGradient(long safeTimeMillis) {
        long now = System.currentTimeMillis();
        long unimprovedTimeMillisSpent = now - (safeTimeMillis - this.unimprovedTimeMillisSpentLimit);
        double timeGradient = (double)unimprovedTimeMillisSpent / (double)this.unimprovedTimeMillisSpentLimit;
        return Math.min(timeGradient, 1.0);
    }

    @Override
    public UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination createChildThreadTermination(DefaultSolverScope solverScope, ChildThreadType childThreadType) {
        return new UnimprovedTimeMillisSpentScoreDifferenceThresholdTermination(this.unimprovedTimeMillisSpentLimit, this.unimprovedScoreDifferenceThreshold);
    }

    public String toString() {
        return "UnimprovedTimeMillisSpent(" + this.unimprovedTimeMillisSpentLimit + ")";
    }
}

