/*
 * Decompiled with CFR 0.152.
 */
package org.optaplanner.core.impl.solver.thread;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class DefaultSolverThreadFactory
implements ThreadFactory {
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;

    public DefaultSolverThreadFactory() {
        this("Solver");
    }

    public DefaultSolverThreadFactory(String threadPrefix) {
        SecurityManager s2 = System.getSecurityManager();
        this.group = s2 != null ? s2.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = "OptaPool-" + poolNumber.getAndIncrement() + "-" + threadPrefix + "-";
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t2 = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
        if (t2.isDaemon()) {
            t2.setDaemon(false);
        }
        if (t2.getPriority() != 5) {
            t2.setPriority(5);
        }
        return t2;
    }
}

