/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.paxlogging;

import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.paxlogging.PaxLoggingComponent;
import org.apache.camel.component.paxlogging.PaxLoggingConsumer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;

@UriEndpoint(scheme="paxlogging", title="OSGi PAX Logging", syntax="paxlogging:appender", consumerOnly=true, consumerClass=PaxLoggingConsumer.class, label="monitoring")
public class PaxLoggingEndpoint
extends DefaultEndpoint {
    @UriPath
    @Metadata(required="true")
    private final String appender;

    public PaxLoggingEndpoint(String uri, PaxLoggingComponent component, String appender) {
        super(uri, (Component)component);
        this.appender = appender;
    }

    public String getAppender() {
        return this.appender;
    }

    @Deprecated
    public String getName() {
        return this.getAppender();
    }

    public PaxLoggingComponent getComponent() {
        return (PaxLoggingComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        throw new RuntimeCamelException("Cannot produce to a PaxLoggingEndpoint: " + this.getEndpointUri());
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        PaxLoggingConsumer answer = new PaxLoggingConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public boolean isSingleton() {
        return true;
    }
}

