/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.MDC;
import org.apache.log4j.Priority;
import org.ops4j.pax.logging.PaxContext;
import org.ops4j.pax.logging.PaxLogger;
import org.ops4j.pax.logging.service.internal.PaxLoggingServiceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleRevision;

public class PaxLoggerImpl
implements PaxLogger {
    private Logger m_delegate;
    private String m_fqcn;
    private Bundle m_bundle;
    private BundleRevision m_bundleRevision;
    private Long m_bundleId;
    private String m_bundleSymbolicName;
    private String m_bundleVersion;
    private PaxLoggingServiceImpl m_service;

    PaxLoggerImpl(Bundle bundle, Logger delegate, String fqcn, PaxLoggingServiceImpl service) {
        this.m_delegate = delegate;
        this.m_fqcn = fqcn;
        this.m_bundle = bundle;
        this.m_service = service;
    }

    @Override
    public boolean isTraceEnabled() {
        return this.m_delegate.isTraceEnabled();
    }

    @Override
    public boolean isDebugEnabled() {
        return this.m_delegate.isDebugEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.m_delegate.isEnabledFor(Level.WARN);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.m_delegate.isInfoEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.m_delegate.isEnabledFor(Level.ERROR);
    }

    @Override
    public boolean isFatalEnabled() {
        return this.m_delegate.isEnabledFor(Level.FATAL);
    }

    private void setDelegateContext() {
        Map<String, Object> context = this.getPaxContext().getContext();
        if (context != null) {
            Iterator<String> i$ = context.keySet().iterator();
            while (i$.hasNext()) {
                String o;
                String key = o = i$.next();
                Object value = context.get(key);
                MDC.put(key, value);
            }
        }
        if (this.m_bundle != null) {
            BundleRevision rev = (BundleRevision)this.m_bundle.adapt(BundleRevision.class);
            if (rev != this.m_bundleRevision) {
                this.m_bundleId = this.m_bundle.getBundleId();
                this.m_bundleSymbolicName = this.m_bundle.getSymbolicName();
                this.m_bundleVersion = this.m_bundle.getVersion().toString();
                this.m_bundleRevision = rev;
            }
            this.put("bundle.id", this.m_bundleId);
            this.put("bundle.name", this.m_bundleSymbolicName);
            this.put("bundle.version", this.m_bundleVersion);
        }
        this.m_service.getConfigLock().readLock().lock();
    }

    private void put(String name, Object o) {
        if (o != null) {
            MDC.put(name, o);
        }
    }

    private void clearDelegateContext() {
        this.m_service.getConfigLock().readLock().unlock();
        if (MDC.getContext() != null) {
            ((Hashtable)MDC.getContext()).clear();
        }
    }

    @Override
    public void trace(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.TRACE, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    @Override
    public void debug(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.DEBUG, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    @Override
    public void inform(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.INFO, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.WARN, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
    }

    @Override
    public void error(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.ERROR, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, Level.FATAL, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    @Override
    public void trace(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.TRACE, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    @Override
    public void debug(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.DEBUG, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 4, message, t);
    }

    @Override
    public void inform(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.INFO, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 3, message, t);
    }

    @Override
    public void warn(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.WARN, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 2, message, t);
    }

    @Override
    public void error(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.ERROR, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    @Override
    public void fatal(String message, Throwable t, String fqcn) {
        this.setDelegateContext();
        this.m_delegate.log(fqcn, Level.FATAL, message, t);
        this.clearDelegateContext();
        this.m_service.handleEvents(this.m_bundle, null, 1, message, t);
    }

    @Override
    public int getLogLevel() {
        return this.m_delegate.getLevel().toInt();
    }

    @Override
    public String getName() {
        return this.m_delegate.getName();
    }

    public void log(Priority level, Object message, Throwable t) {
        this.setDelegateContext();
        this.m_delegate.log(this.m_fqcn, level, message, t);
        this.clearDelegateContext();
    }

    @Override
    public PaxContext getPaxContext() {
        return this.m_service.getPaxContext();
    }
}

