/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.log4j.Category;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggerRepository;
import org.apache.log4j.spi.LoggingEvent;

public class SocketNode
implements Runnable {
    Socket socket;
    LoggerRepository hierarchy;
    ObjectInputStream ois;
    static Logger logger = Logger.getLogger(class$org$apache$log4j$net$SocketNode == null ? (class$org$apache$log4j$net$SocketNode = SocketNode.class$("org.apache.log4j.net.SocketNode")) : class$org$apache$log4j$net$SocketNode);
    static /* synthetic */ Class class$org$apache$log4j$net$SocketNode;

    public SocketNode(Socket socket, LoggerRepository hierarchy) {
        this.socket = socket;
        this.hierarchy = hierarchy;
        try {
            this.ois = new ObjectInputStream(new BufferedInputStream(socket.getInputStream()));
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
            ((Category)logger).error("Could not open ObjectInputStream to " + socket, e);
        }
        catch (IOException e) {
            ((Category)logger).error("Could not open ObjectInputStream to " + socket, e);
        }
        catch (RuntimeException e) {
            ((Category)logger).error("Could not open ObjectInputStream to " + socket, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            if (this.ois != null) {
                while (true) {
                    LoggingEvent event = (LoggingEvent)this.ois.readObject();
                    Logger remoteLogger = this.hierarchy.getLogger(event.getLoggerName());
                    if (!event.getLevel().isGreaterOrEqual(remoteLogger.getEffectiveLevel())) continue;
                    remoteLogger.callAppenders(event);
                }
            }
        }
        catch (EOFException e) {
            ((Category)logger).info("Caught java.io.EOFException closing conneciton.");
        }
        catch (SocketException e) {
            ((Category)logger).info("Caught java.net.SocketException closing conneciton.");
        }
        catch (InterruptedIOException e) {
            Thread.currentThread().interrupt();
            ((Category)logger).info("Caught java.io.InterruptedIOException: " + e);
            ((Category)logger).info("Closing connection.");
        }
        catch (IOException e) {
            ((Category)logger).info("Caught java.io.IOException: " + e);
            ((Category)logger).info("Closing connection.");
        }
        catch (Exception e) {
            ((Category)logger).error("Unexpected exception. Closing conneciton.", e);
        }
        finally {
            if (this.ois != null) {
                try {
                    this.ois.close();
                }
                catch (Exception e) {
                    ((Category)logger).info("Could not close connection.", e);
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (InterruptedIOException e) {
                    Thread.currentThread().interrupt();
                }
                catch (IOException ex) {}
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

