/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.logging.service.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;
import org.osgi.service.log.LogEntry;
import org.osgi.service.log.LogListener;
import org.osgi.service.log.LogReaderService;

public class LogReaderServiceImpl
implements LogReaderService {
    private List m_listeners;
    private final LinkedList m_entries;
    private int m_maxEntries;

    public LogReaderServiceImpl(int maxEntries) {
        this.m_maxEntries = maxEntries;
        this.m_entries = new LinkedList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLogListener(LogListener logListener) {
        LogReaderServiceImpl logReaderServiceImpl = this;
        synchronized (logReaderServiceImpl) {
            ArrayList<LogListener> clone = this.m_listeners == null ? new ArrayList<LogListener>() : new ArrayList(this.m_listeners);
            clone.add(logListener);
            this.m_listeners = clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLogListener(LogListener logListener) {
        LogReaderServiceImpl logReaderServiceImpl = this;
        synchronized (logReaderServiceImpl) {
            if (this.m_listeners == null) {
                return;
            }
            ArrayList clone = new ArrayList(this.m_listeners);
            clone.remove(logListener);
            this.m_listeners = clone.size() == 0 ? null : clone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration getLog() {
        LinkedList linkedList = this.m_entries;
        synchronized (linkedList) {
            return Collections.enumeration(new ArrayList(this.m_entries));
        }
    }

    private void cleanUp() {
        while (this.m_entries.size() > this.m_maxEntries) {
            this.m_entries.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void fireEvent(LogEntry entry) {
        LinkedList linkedList = this.m_entries;
        synchronized (linkedList) {
            this.m_entries.addFirst(entry);
            this.cleanUp();
        }
        List listeners = this.m_listeners;
        if (listeners == null) {
            return;
        }
        for (LogListener listener : listeners) {
            this.fire(listener, entry);
        }
    }

    private void fire(LogListener listener, LogEntry entry) {
        try {
            listener.logged(entry);
        }
        catch (Throwable e) {
            System.err.println("'" + listener + "' is removed as a LogListener, since it threw an exception.");
            this.removeLogListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setMaxEntries(int maxSize) {
        LinkedList linkedList = this.m_entries;
        synchronized (linkedList) {
            this.m_maxEntries = maxSize;
        }
    }
}

