/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.component.pdf.PdfOperation;
import org.apache.camel.component.pdf.TextProcessingFactory;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

@UriParams
public class PdfConfiguration {
    private static final Map<String, PDRectangle> PAGE_MAP = new HashMap<String, PDRectangle>();
    @UriPath(description="Operation type")
    @Metadata(required="true")
    private PdfOperation operation;
    @UriParam(defaultValue="20")
    private int marginTop = 20;
    @UriParam(defaultValue="20")
    private int marginBottom = 20;
    @UriParam(defaultValue="20")
    private int marginLeft = 20;
    @UriParam(defaultValue="40")
    private int marginRight = 40;
    @UriParam(defaultValue="14")
    private float fontSize = 14.0f;
    @UriParam(defaultValue="PAGE_SIZE_A4", enums="PAGE_SIZE_A0,PAGE_SIZE_A1,PAGE_SIZE_A2,PAGE_SIZE_A3,PAGE_SIZE_A4,PAGE_SIZE_A5,PAGE_SIZE_A6,PAGE_SIZE_LETTER")
    private PDRectangle pageSize = PDPage.PAGE_SIZE_A4;
    @UriParam(defaultValue="Helvetica")
    private PDFont font = PDType1Font.HELVETICA;
    @UriParam(defaultValue="lineTermination")
    private TextProcessingFactory textProcessingFactory = TextProcessingFactory.lineTermination;

    public PdfOperation getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = PdfOperation.valueOf(operation);
    }

    public void setOperation(PdfOperation operation) {
        this.operation = operation;
    }

    public int getMarginTop() {
        return this.marginTop;
    }

    public void setMarginTop(int marginTop) {
        this.marginTop = marginTop;
    }

    public int getMarginBottom() {
        return this.marginBottom;
    }

    public void setMarginBottom(int marginBottom) {
        this.marginBottom = marginBottom;
    }

    public int getMarginLeft() {
        return this.marginLeft;
    }

    public void setMarginLeft(int marginLeft) {
        this.marginLeft = marginLeft;
    }

    public int getMarginRight() {
        return this.marginRight;
    }

    public void setMarginRight(int marginRight) {
        this.marginRight = marginRight;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public PDRectangle getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(PDRectangle pageSize) {
        this.pageSize = pageSize;
    }

    public void setPageSize(String pageSize) {
        this.setPageSize(PAGE_MAP.get(pageSize));
    }

    public PDFont getFont() {
        return this.font;
    }

    public void setFont(PDFont font) {
        this.font = font;
    }

    public void setFont(String font) {
        this.setFont(PDType1Font.getStandardFont(font));
    }

    public TextProcessingFactory getTextProcessingFactory() {
        return this.textProcessingFactory;
    }

    public void setTextProcessingFactory(TextProcessingFactory textProcessingFactory) {
        this.textProcessingFactory = textProcessingFactory;
    }

    public void setTextProcessingFactory(String textProcessingFactory) {
        this.textProcessingFactory = TextProcessingFactory.valueOf(textProcessingFactory);
    }

    static {
        PAGE_MAP.put("PAGE_SIZE_A0", PDPage.PAGE_SIZE_A0);
        PAGE_MAP.put("PAGE_SIZE_A1", PDPage.PAGE_SIZE_A1);
        PAGE_MAP.put("PAGE_SIZE_A2", PDPage.PAGE_SIZE_A2);
        PAGE_MAP.put("PAGE_SIZE_A3", PDPage.PAGE_SIZE_A3);
        PAGE_MAP.put("PAGE_SIZE_A4", PDPage.PAGE_SIZE_A4);
        PAGE_MAP.put("PAGE_SIZE_A5", PDPage.PAGE_SIZE_A5);
        PAGE_MAP.put("PAGE_SIZE_A6", PDPage.PAGE_SIZE_A6);
        PAGE_MAP.put("PAGE_SIZE_LETTER", PDPage.PAGE_SIZE_LETTER);
    }
}

