/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.component.pdf.PdfConfiguration;
import org.apache.camel.component.pdf.PdfEndpoint;
import org.apache.camel.component.pdf.text.AutoFormattedWriterAbstractFactory;
import org.apache.camel.component.pdf.text.LineBuilderStrategy;
import org.apache.camel.component.pdf.text.LineTerminationWriterAbstractFactory;
import org.apache.camel.component.pdf.text.SplitStrategy;
import org.apache.camel.component.pdf.text.TextProcessingAbstractFactory;
import org.apache.camel.component.pdf.text.WriteStrategy;
import org.apache.camel.impl.DefaultProducer;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.exceptions.InvalidPasswordException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.ProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.StandardProtectionPolicy;
import org.apache.pdfbox.util.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(PdfProducer.class);
    private final WriteStrategy writeStrategy;
    private final SplitStrategy splitStrategy;
    private final LineBuilderStrategy lineBuilderStrategy;
    private final PdfConfiguration pdfConfiguration;

    public PdfProducer(PdfEndpoint endpoint) {
        super((Endpoint)endpoint);
        this.pdfConfiguration = endpoint.getPdfConfiguration();
        TextProcessingAbstractFactory textProcessingFactory = this.createTextProcessingFactory(this.pdfConfiguration);
        this.writeStrategy = textProcessingFactory.createWriteStrategy();
        this.splitStrategy = textProcessingFactory.createSplitStrategy();
        this.lineBuilderStrategy = textProcessingFactory.createLineBuilderStrategy();
    }

    public void process(Exchange exchange) throws Exception {
        Object result;
        switch (this.pdfConfiguration.getOperation()) {
            case append: {
                result = this.doAppend(exchange);
                break;
            }
            case create: {
                result = this.doCreate(exchange);
                break;
            }
            case extractText: {
                result = this.doExtractText(exchange);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown operation %s", new Object[]{this.pdfConfiguration.getOperation()}));
            }
        }
        exchange.getOut().setHeaders(exchange.getIn().getHeaders());
        exchange.getOut().setAttachments(exchange.getIn().getAttachments());
        exchange.getOut().setBody(result);
    }

    private Object doAppend(Exchange exchange) throws IOException, BadSecurityHandlerException, CryptographyException, InvalidPasswordException, COSVisitorException {
        LOG.debug("Got {} operation, going to append text to provided pdf.", (Object)this.pdfConfiguration.getOperation());
        String body = (String)exchange.getIn().getBody(String.class);
        PDDocument document = (PDDocument)exchange.getIn().getHeader("pdf-document", PDDocument.class);
        if (document == null) {
            throw new IllegalArgumentException(String.format("%s header is expected for append operation", "pdf-document"));
        }
        if (document.isEncrypted()) {
            DecryptionMaterial decryptionMaterial = (DecryptionMaterial)exchange.getIn().getHeader("decryption-material", DecryptionMaterial.class);
            if (decryptionMaterial == null) {
                throw new IllegalArgumentException(String.format("%s header is expected for %s operation on encrypted document", new Object[]{"decryption-material", this.pdfConfiguration.getOperation()}));
            }
            document.openProtection(decryptionMaterial);
            document.setAllSecurityToBeRemoved(true);
        }
        ProtectionPolicy protectionPolicy = (ProtectionPolicy)exchange.getIn().getHeader("protection-policy", ProtectionPolicy.class);
        this.appendToPdfDocument(body, document, protectionPolicy);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save(byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    private String doExtractText(Exchange exchange) throws IOException, CryptographyException, InvalidPasswordException, BadSecurityHandlerException {
        LOG.debug("Got {} operation, going to extract text from provided pdf.", (Object)this.pdfConfiguration.getOperation());
        PDDocument document = (PDDocument)exchange.getIn().getBody(PDDocument.class);
        if (document.isEncrypted()) {
            DecryptionMaterial decryptionMaterial = (DecryptionMaterial)exchange.getIn().getHeader("decryption-material", DecryptionMaterial.class);
            if (decryptionMaterial == null) {
                throw new IllegalArgumentException(String.format("%s header is expected for %s operation on encrypted document", new Object[]{"decryption-material", this.pdfConfiguration.getOperation()}));
            }
            document.openProtection(decryptionMaterial);
        }
        PDFTextStripper pdfTextStripper = new PDFTextStripper();
        return pdfTextStripper.getText(document);
    }

    private OutputStream doCreate(Exchange exchange) throws IOException, BadSecurityHandlerException, COSVisitorException {
        LOG.debug("Got {} operation, going to create and write provided string to pdf document.", (Object)this.pdfConfiguration.getOperation());
        String body = (String)exchange.getIn().getBody(String.class);
        PDDocument document = new PDDocument();
        StandardProtectionPolicy protectionPolicy = (StandardProtectionPolicy)exchange.getIn().getHeader("protection-policy", StandardProtectionPolicy.class);
        this.appendToPdfDocument(body, document, protectionPolicy);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        document.save(byteArrayOutputStream);
        return byteArrayOutputStream;
    }

    private void appendToPdfDocument(String text, PDDocument document, ProtectionPolicy protectionPolicy) throws IOException, BadSecurityHandlerException {
        Collection<String> words = this.splitStrategy.split(text);
        Collection<String> lines = this.lineBuilderStrategy.buildLines(words);
        this.writeStrategy.write(lines, document);
        if (protectionPolicy != null) {
            document.protect(protectionPolicy);
        }
    }

    private TextProcessingAbstractFactory createTextProcessingFactory(PdfConfiguration pdfConfiguration) {
        TextProcessingAbstractFactory result;
        switch (pdfConfiguration.getTextProcessingFactory()) {
            case autoFormatting: {
                result = new AutoFormattedWriterAbstractFactory(pdfConfiguration);
                break;
            }
            case lineTermination: {
                result = new LineTerminationWriterAbstractFactory(pdfConfiguration);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unknown text processing factory %s", new Object[]{pdfConfiguration.getTextProcessingFactory()}));
            }
        }
        return result;
    }
}

