/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Iterator;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.pdmodel.encryption.DecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyDecryptionMaterial;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyProtectionPolicy;
import org.apache.pdfbox.pdmodel.encryption.PublicKeyRecipient;
import org.apache.pdfbox.pdmodel.encryption.SecurityHandler;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.RecipientInformation;

public class PublicKeySecurityHandler
extends SecurityHandler {
    private static final Log LOG = LogFactory.getLog(PublicKeySecurityHandler.class);
    public static final String FILTER = "Adobe.PubSec";
    private static final String SUBFILTER = "adbe.pkcs7.s4";
    private PublicKeyProtectionPolicy policy = null;

    public PublicKeySecurityHandler() {
    }

    public PublicKeySecurityHandler(PublicKeyProtectionPolicy p) {
        this.policy = p;
        this.keyLength = this.policy.getEncryptionKeyLength();
    }

    public void decryptDocument(PDDocument doc, DecryptionMaterial decryptionMaterial) throws CryptographyException, IOException {
        this.document = doc;
        PDEncryptionDictionary dictionary = doc.getEncryptionDictionary();
        this.prepareForDecryption(dictionary, doc.getDocument().getDocumentID(), decryptionMaterial);
        this.proceedDecryption();
    }

    public void prepareForDecryption(PDEncryptionDictionary encDictionary, COSArray documentIDArray, DecryptionMaterial decryptionMaterial) throws CryptographyException, IOException {
        if (!(decryptionMaterial instanceof PublicKeyDecryptionMaterial)) {
            throw new CryptographyException("Provided decryption material is not compatible with the document");
        }
        this.decryptMetadata = encDictionary.isEncryptMetaData();
        if (encDictionary.getLength() != 0) {
            this.keyLength = encDictionary.getLength();
        }
        PublicKeyDecryptionMaterial material = (PublicKeyDecryptionMaterial)decryptionMaterial;
        try {
            boolean foundRecipient = false;
            byte[] envelopedData = null;
            byte[][] recipientFieldsBytes = new byte[encDictionary.getRecipientsLength()][];
            int recipientFieldsLength = 0;
            for (int i = 0; i < encDictionary.getRecipientsLength(); ++i) {
                COSString recipientFieldString = encDictionary.getRecipientStringAt(i);
                byte[] recipientBytes = recipientFieldString.getBytes();
                CMSEnvelopedData data = new CMSEnvelopedData(recipientBytes);
                for (RecipientInformation ri : data.getRecipientInfos().getRecipients()) {
                    if (!ri.getRID().match(material.getCertificate()) || foundRecipient) continue;
                    foundRecipient = true;
                    envelopedData = ri.getContent(material.getPrivateKey(), "BC");
                    break;
                }
                recipientFieldsBytes[i] = recipientBytes;
                recipientFieldsLength += recipientBytes.length;
            }
            if (!foundRecipient || envelopedData == null) {
                throw new CryptographyException("The certificate matches no recipient entry");
            }
            if (envelopedData.length != 24) {
                throw new CryptographyException("The enveloped data does not contain 24 bytes");
            }
            byte[] accessBytes = new byte[4];
            System.arraycopy(envelopedData, 20, accessBytes, 0, 4);
            this.currentAccessPermission = new AccessPermission(accessBytes);
            this.currentAccessPermission.setReadOnly();
            byte[] sha1Input = new byte[recipientFieldsLength + 20];
            System.arraycopy(envelopedData, 0, sha1Input, 0, 20);
            int sha1InputOffset = 20;
            for (int i = 0; i < recipientFieldsBytes.length; ++i) {
                System.arraycopy(recipientFieldsBytes[i], 0, sha1Input, sha1InputOffset, recipientFieldsBytes[i].length);
                sha1InputOffset += recipientFieldsBytes[i].length;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] mdResult = md.digest(sha1Input);
            this.encryptionKey = new byte[this.keyLength / 8];
            System.arraycopy(mdResult, 0, this.encryptionKey, 0, this.keyLength / 8);
        }
        catch (CMSException e) {
            throw new CryptographyException(e);
        }
        catch (KeyStoreException e) {
            throw new CryptographyException(e);
        }
        catch (NoSuchProviderException e) {
            throw new CryptographyException(e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptographyException(e);
        }
    }

    public void prepareDocumentForEncryption(PDDocument doc) throws CryptographyException {
        try {
            PDEncryptionDictionary dictionary = doc.getEncryptionDictionary();
            if (dictionary == null) {
                dictionary = new PDEncryptionDictionary();
            }
            dictionary.setFilter(FILTER);
            dictionary.setLength(this.keyLength);
            dictionary.setVersion(2);
            dictionary.removeV45filters();
            dictionary.setSubFilter(SUBFILTER);
            byte[][] recipientsField = new byte[this.policy.getRecipientsNumber()][];
            byte[] seed = new byte[20];
            KeyGenerator key = KeyGenerator.getInstance("AES");
            key.init(192, new SecureRandom());
            SecretKey sk = key.generateKey();
            System.arraycopy(sk.getEncoded(), 0, seed, 0, 20);
            Iterator it = this.policy.getRecipientsIterator();
            int i = 0;
            while (it.hasNext()) {
                PublicKeyRecipient recipient = (PublicKeyRecipient)it.next();
                X509Certificate certificate = recipient.getX509();
                int permission = recipient.getPermission().getPermissionBytesForPublicKey();
                byte[] pkcs7input = new byte[24];
                byte one = (byte)permission;
                byte two = (byte)(permission >>> 8);
                byte three = (byte)(permission >>> 16);
                byte four = (byte)(permission >>> 24);
                System.arraycopy(seed, 0, pkcs7input, 0, 20);
                pkcs7input[20] = four;
                pkcs7input[21] = three;
                pkcs7input[22] = two;
                pkcs7input[23] = one;
                DERObject obj = this.createDERForRecipient(pkcs7input, certificate);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DEROutputStream k = new DEROutputStream(baos);
                k.writeObject(obj);
                recipientsField[i] = baos.toByteArray();
                ++i;
            }
            dictionary.setRecipients(recipientsField);
            int sha1InputLength = seed.length;
            for (int j = 0; j < dictionary.getRecipientsLength(); ++j) {
                COSString string = dictionary.getRecipientStringAt(j);
                sha1InputLength += string.getBytes().length;
            }
            byte[] sha1Input = new byte[sha1InputLength];
            System.arraycopy(seed, 0, sha1Input, 0, 20);
            int sha1InputOffset = 20;
            for (int j = 0; j < dictionary.getRecipientsLength(); ++j) {
                COSString string = dictionary.getRecipientStringAt(j);
                System.arraycopy(string.getBytes(), 0, sha1Input, sha1InputOffset, string.getBytes().length);
                sha1InputOffset += string.getBytes().length;
            }
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] mdResult = md.digest(sha1Input);
            this.encryptionKey = new byte[this.keyLength / 8];
            System.arraycopy(mdResult, 0, this.encryptionKey, 0, this.keyLength / 8);
            doc.setEncryptionDictionary(dictionary);
            doc.getDocument().setEncryptionDictionary(dictionary.encryptionDictionary);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new CryptographyException(ex);
        }
        catch (NoSuchProviderException ex) {
            throw new CryptographyException(ex);
        }
        catch (Exception e) {
            LOG.error((Object)e, (Throwable)e);
            throw new CryptographyException(e);
        }
    }

    private DERObject createDERForRecipient(byte[] in, X509Certificate cert) throws IOException, GeneralSecurityException {
        KeyGenerator keygenerator;
        String s = "1.2.840.113549.3.2";
        AlgorithmParameterGenerator algorithmparametergenerator = AlgorithmParameterGenerator.getInstance(s);
        AlgorithmParameters algorithmparameters = algorithmparametergenerator.generateParameters();
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(algorithmparameters.getEncoded("ASN.1"));
        ASN1InputStream asn1inputstream = new ASN1InputStream(bytearrayinputstream);
        DERObject derobject = asn1inputstream.readObject();
        try {
            keygenerator = KeyGenerator.getInstance(s);
        }
        catch (NoSuchAlgorithmException e) {
            throw new NoSuchAlgorithmException("Could not find a suitable javax.crypto provider for algorithm " + s + "; possible reason: using an unsigned .jar file", e);
        }
        keygenerator.init(128);
        SecretKey secretkey = keygenerator.generateKey();
        Cipher cipher = Cipher.getInstance(s);
        cipher.init(1, (Key)secretkey, algorithmparameters);
        byte[] abyte1 = cipher.doFinal(in);
        DEROctetString deroctetstring = new DEROctetString(abyte1);
        KeyTransRecipientInfo keytransrecipientinfo = this.computeRecipientInfo(cert, secretkey.getEncoded());
        DERSet derset = new DERSet((DEREncodable)new RecipientInfo(keytransrecipientinfo));
        AlgorithmIdentifier algorithmidentifier = new AlgorithmIdentifier(new DERObjectIdentifier(s), (DEREncodable)derobject);
        EncryptedContentInfo encryptedcontentinfo = new EncryptedContentInfo((DERObjectIdentifier)PKCSObjectIdentifiers.data, algorithmidentifier, (ASN1OctetString)deroctetstring);
        EnvelopedData env = new EnvelopedData(null, (ASN1Set)derset, encryptedcontentinfo, null);
        ContentInfo contentinfo = new ContentInfo((DERObjectIdentifier)PKCSObjectIdentifiers.envelopedData, (DEREncodable)env);
        return contentinfo.getDERObject();
    }

    private KeyTransRecipientInfo computeRecipientInfo(X509Certificate x509certificate, byte[] abyte0) throws GeneralSecurityException, IOException {
        ASN1InputStream asn1inputstream = new ASN1InputStream(new ByteArrayInputStream(x509certificate.getTBSCertificate()));
        TBSCertificateStructure tbscertificatestructure = TBSCertificateStructure.getInstance(asn1inputstream.readObject());
        AlgorithmIdentifier algorithmidentifier = tbscertificatestructure.getSubjectPublicKeyInfo().getAlgorithmId();
        IssuerAndSerialNumber issuerandserialnumber = new IssuerAndSerialNumber(tbscertificatestructure.getIssuer(), tbscertificatestructure.getSerialNumber().getValue());
        Cipher cipher = Cipher.getInstance(algorithmidentifier.getObjectId().getId());
        cipher.init(1, x509certificate.getPublicKey());
        DEROctetString deroctetstring = new DEROctetString(cipher.doFinal(abyte0));
        RecipientIdentifier recipId = new RecipientIdentifier(issuerandserialnumber);
        return new KeyTransRecipientInfo(recipId, algorithmidentifier, deroctetstring);
    }

    public boolean hasProtectionPolicy() {
        return this.policy != null;
    }
}

