/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.jdbc.spy.ConnectionRelay;
import com.impossibl.jdbc.spy.ConnectionTracer;
import com.impossibl.jdbc.spy.SimpleTraceOutput;
import com.impossibl.postgres.jdbc.JDBCSettings;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.system.Configuration;
import com.impossibl.postgres.system.Settings;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class APITracing {
    private static final Logger logger = Logger.getLogger(APITracing.class.getName());

    public static Connection setupIfEnabled(PGDirectConnection connection) {
        return APITracing.setupIfEnabled((Connection)connection, connection);
    }

    public static Connection setupIfEnabled(Connection connection, Configuration config) {
        if (!config.getSetting(JDBCSettings.API_TRACE).booleanValue()) {
            return connection;
        }
        return APITracing.setup(connection, config.getSetting(JDBCSettings.API_TRACE_FILE));
    }

    public static Connection setupIfEnabled(Connection connection, Settings settings) {
        if (!settings.get(JDBCSettings.API_TRACE).booleanValue()) {
            return connection;
        }
        return APITracing.setup(connection, settings.get(JDBCSettings.API_TRACE_FILE));
    }

    public static ConnectionRelay setup(Connection connection, String file) {
        OutputStream out = System.out;
        if (file != null) {
            try {
                out = new FileOutputStream(file);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to initialize API tracing", e);
                return null;
            }
        }
        return new ConnectionRelay(connection, new ConnectionTracer(new SimpleTraceOutput(new OutputStreamWriter(out))));
    }
}

