/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.ErrorUtils;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PGResultSet;
import com.impossibl.postgres.jdbc.PGSQLSimpleException;
import com.impossibl.postgres.jdbc.PGStatement;
import com.impossibl.postgres.jdbc.Scroller;
import com.impossibl.postgres.protocol.FieldBuffersRowData;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.protocol.RowData;
import com.impossibl.postgres.protocol.UpdatableRowData;
import com.impossibl.postgres.system.Context;
import com.impossibl.postgres.types.CompositeType;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;

class CursorScroller
extends Scroller {
    private PGDirectConnection connection;
    private String cursorName;
    private int type;
    private int holdability;
    private ResultField[] resultFields;
    private int rowIndexValue;
    private int lastRowIndexValue;
    private Integer rowCountCache;
    private int rowIndexSign;
    private RowData result;

    CursorScroller(PGResultSet resultSet, String cursorName, int type, int holdability, ResultField[] resultFields) {
        this.connection = resultSet.statement.connection;
        this.cursorName = cursorName;
        this.type = type;
        this.holdability = holdability;
        this.resultFields = resultFields;
        this.setRowIndex(0, true);
    }

    private void setRowIndex(int value, boolean sign) {
        this.lastRowIndexValue = this.rowIndexValue = value;
        this.rowIndexSign = sign ? 1 : -1;
    }

    void setResult(RowData result) {
        ReferenceCountUtil.release(this.result);
        this.result = result;
    }

    private boolean fetch(String type, Object loc) throws SQLException {
        String sb = "FETCH " + type + " " + loc + " FROM " + this.cursorName;
        this.setResult(this.connection.executeForResult(sb));
        return this.result != null;
    }

    private int move(String type, Object loc) throws SQLException {
        this.setResult(null);
        String sb = "MOVE " + type + " " + loc + " IN " + this.cursorName;
        return (int)this.connection.executeForRowsAffected(sb);
    }

    private int getRealRowCount() throws SQLException {
        if (this.rowCountCache == null) {
            this.move("ABSOLUTE", 0);
            this.rowCountCache = this.move("FORWARD", "ALL");
            this.move("ABSOLUTE", this.getRow());
        }
        return this.rowCountCache;
    }

    @Override
    void close() throws SQLException {
        this.setResult(null);
        if (this.holdability == 1) {
            PGStatement.closeCursor(this.connection, this.cursorName);
        }
    }

    @Override
    ResultField[] getResultFields() {
        return this.resultFields;
    }

    @Override
    boolean isValidRow() {
        return this.result != null && this.rowIndexValue != Integer.MAX_VALUE;
    }

    @Override
    String getCursorName() {
        return this.cursorName;
    }

    @Override
    public int getRow() throws SQLException {
        if (!this.isValidRow()) {
            return 0;
        }
        if (this.rowIndexSign < 0) {
            return this.getRealRowCount() - this.rowIndexValue + 1;
        }
        return this.rowIndexValue;
    }

    @Override
    Object getRowField(int fieldIndex, Context context, Class<?> targetType, Object targetContext) throws IOException {
        return this.getRowData().getField(fieldIndex, this.resultFields[fieldIndex], context, targetType, targetContext);
    }

    @Override
    RowData getRowData() {
        return this.result;
    }

    @Override
    UpdatableRowData getUpdatableRowData() {
        if (this.result == null || this.result instanceof UpdatableRowData) {
            return (UpdatableRowData)this.result;
        }
        UpdatableRowData updatableResult = this.result.duplicateForUpdate();
        ReferenceCountUtil.release(this.result);
        this.result = updatableResult;
        return updatableResult;
    }

    @Override
    void createInsertRowData() {
        this.setResult(new FieldBuffersRowData(this.resultFields, this.connection.getAllocator()));
        this.rowIndexValue = Integer.MAX_VALUE;
    }

    @Override
    int getType() {
        return this.type;
    }

    @Override
    int getConcurrency() {
        return 1008;
    }

    @Override
    int getHoldability() {
        return this.holdability;
    }

    @Override
    public boolean isBeforeFirst() {
        return (this.rowCountCache == null || this.rowCountCache != 0) && this.rowIndexValue == 0 && this.rowIndexSign == 1;
    }

    @Override
    public boolean isAfterLast() {
        return (this.rowCountCache == null || this.rowCountCache != 0) && this.rowIndexValue == 0 && this.rowIndexSign == -1;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (!this.isValidRow()) {
            return false;
        }
        if (this.rowIndexSign == 1) {
            return this.rowIndexValue == 1;
        }
        if (this.rowCountCache == null) {
            boolean isFirst = this.move("RELATIVE", -1) == 0;
            this.move("RELATIVE", 1);
            return isFirst;
        }
        return this.rowIndexValue == this.rowCountCache;
    }

    @Override
    public boolean isLast() throws SQLException {
        if (this.type == 1003) {
            throw new SQLFeatureNotSupportedException("cannot call isLast on forward-only cursors");
        }
        if (!this.isValidRow()) {
            return false;
        }
        if (this.rowIndexSign == -1) {
            return this.rowIndexValue == 1;
        }
        if (this.rowCountCache == null) {
            boolean isLast = this.move("RELATIVE", 1) == 0;
            this.move("RELATIVE", -1);
            return isLast;
        }
        return this.rowIndexValue == this.rowCountCache;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.move("ABSOLUTE", 0);
        this.setRowIndex(0, true);
    }

    @Override
    public void afterLast() throws SQLException {
        this.rowIndexValue += this.move("FORWARD", "ALL") * this.rowIndexSign;
    }

    @Override
    public boolean first() throws SQLException {
        if (this.fetch("FIRST", "")) {
            this.setRowIndex(1, true);
            return true;
        }
        this.setRowIndex(0, true);
        this.rowCountCache = 0;
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        if (this.fetch("LAST", "")) {
            this.setRowIndex(1, false);
            return true;
        }
        this.setRowIndex(0, true);
        this.rowCountCache = 0;
        return false;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        if (this.fetch("ABSOLUTE", row)) {
            this.setRowIndex(Math.abs(row), row > 0);
            return true;
        }
        this.setRowIndex(0, row == 0 || row < 0);
        return false;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        if (this.fetch("RELATIVE", rows)) {
            this.rowIndexValue += rows * this.rowIndexSign;
            return true;
        }
        if (rows < 0) {
            this.setRowIndex(0, true);
        } else if (rows == 1) {
            if (this.rowIndexSign > 0) {
                this.rowCountCache = this.rowIndexValue;
            }
            this.setRowIndex(0, false);
        } else {
            this.setRowIndex(0, true);
        }
        return false;
    }

    @Override
    public boolean next() throws SQLException {
        return this.relative(1);
    }

    @Override
    boolean previous() throws SQLException {
        return this.relative(-1);
    }

    @Override
    void insert() throws SQLException {
        CompositeType relType;
        if (!(this.result instanceof UpdatableRowData) || this.rowIndexValue != Integer.MAX_VALUE) {
            throw new PGSQLSimpleException("not on insert row");
        }
        UpdatableRowData rowData = (UpdatableRowData)this.result;
        try {
            relType = this.connection.getRegistry().loadRelationType(this.resultFields[0].getRelationId());
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        StringBuilder sb = new StringBuilder("INSERT INTO ");
        sb.append('\"').append(relType.getName()).append('\"');
        sb.append(" VALUES (");
        for (int pid = 0; pid < this.resultFields.length; ++pid) {
            sb.append("$");
            sb.append(pid + 1);
            if (pid >= this.resultFields.length - 1) continue;
            sb.append(", ");
        }
        sb.append(")");
        ByteBuf[] paramBuffers = rowData.getFieldBuffers();
        this.connection.executeForRowsAffected(sb.toString(), this.resultFields, paramBuffers);
    }

    @Override
    void update() throws SQLException {
        CompositeType relType;
        if (!(this.result instanceof UpdatableRowData) || this.rowIndexValue == Integer.MAX_VALUE) {
            throw new SQLException("not on update row");
        }
        UpdatableRowData rowData = (UpdatableRowData)this.result;
        try {
            relType = this.connection.getRegistry().loadRelationType(this.resultFields[0].getRelationId());
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        StringBuilder sb = new StringBuilder("UPDATE ");
        sb.append('\"').append(relType.getName()).append('\"');
        sb.append(" SET ");
        for (int pid = 0; pid < this.resultFields.length; ++pid) {
            sb.append(this.resultFields[pid].getName());
            sb.append(" = $");
            sb.append(pid + 1);
            if (pid >= this.resultFields.length - 1) continue;
            sb.append(", ");
        }
        sb.append("WHERE CURRENT OF ");
        sb.append(this.cursorName);
        ByteBuf[] paramBuffers = rowData.getFieldBuffers();
        this.connection.executeForRowsAffected(sb.toString(), this.resultFields, paramBuffers);
    }

    @Override
    void delete() throws SQLException {
        CompositeType relType;
        if (!this.isValidRow()) {
            throw Exceptions.ROW_INDEX_OUT_OF_BOUNDS;
        }
        try {
            relType = this.connection.getRegistry().loadRelationType(this.resultFields[0].getRelationId());
        }
        catch (IOException e) {
            throw ErrorUtils.makeSQLException(e);
        }
        String sql = "DELETE FROM \"" + relType.getName() + '\"' + " WHERE CURRENT OF " + this.cursorName;
        long rows = this.connection.executeForRowsAffected(sql);
        if (rows != 0L) {
            if (this.rowCountCache != null) {
                Integer n = this.rowCountCache;
                this.rowCountCache = this.rowCountCache - 1;
            }
            --this.rowIndexValue;
            this.refresh();
        }
    }

    @Override
    void refresh() throws SQLException {
        this.relative(0);
    }

    @Override
    void cancel() throws SQLException {
        this.rowIndexValue = this.lastRowIndexValue;
        if (this.result instanceof UpdatableRowData) {
            this.refresh();
        }
    }
}

