/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.jdbc.DirectQuery;
import com.impossibl.postgres.jdbc.PGDirectConnection;
import com.impossibl.postgres.jdbc.PreparedQuery;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.ResultBatch;
import com.impossibl.postgres.protocol.ResultField;
import com.impossibl.postgres.system.Empty;
import io.netty.buffer.ByteBuf;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.List;

public interface Query {
    public Status getStatus();

    public Long getTimeout();

    public void setTimeout(Long var1);

    public void setMaxRows(int var1);

    public List<ResultBatch> getResultBatches();

    public SQLWarning execute(PGDirectConnection var1) throws SQLException;

    public void dispose(PGDirectConnection var1) throws SQLException;

    public static Query create(String sqlText) {
        return new DirectQuery(sqlText, Empty.EMPTY_FORMATS, Empty.EMPTY_BUFFERS, Empty.EMPTY_FORMATS);
    }

    public static Query create(String sqlText, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers) {
        if (parameterFormats == null && parameterBuffers == null) {
            return Query.create(sqlText);
        }
        return new DirectQuery(sqlText, parameterFormats, parameterBuffers, Empty.EMPTY_FORMATS);
    }

    public static Query create(String statement, ResultField[] resultFields) {
        return new PreparedQuery(statement, Empty.EMPTY_FORMATS, Empty.EMPTY_BUFFERS, resultFields);
    }

    public static Query create(String statement, FieldFormatRef[] parameterFormats, ByteBuf[] parameterBuffers, ResultField[] resultFields) {
        return new PreparedQuery(statement, parameterFormats, parameterBuffers, resultFields);
    }

    public static enum Status {
        Initialized,
        InProgress,
        Completed,
        Suspended;

    }
}

