/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.protocol;

import com.impossibl.postgres.protocol.FieldFormat;
import com.impossibl.postgres.protocol.FieldFormatRef;
import com.impossibl.postgres.protocol.TypeRef;
import com.impossibl.postgres.types.Type;
import java.util.Objects;

public class ResultField
implements FieldFormatRef {
    private String name;
    private int relationId;
    private short relationAttributeNumber;
    private TypeRef typeRef;
    private short typeLength;
    private int typeModifier;
    private FieldFormat format;

    public ResultField(String name, int relationId, short relationAttributeNumber, Type type, short typeLength, int typeModifier, FieldFormat format) {
        this.name = name;
        this.relationId = relationId;
        this.relationAttributeNumber = relationAttributeNumber;
        this.typeRef = type;
        this.typeLength = typeLength;
        this.typeModifier = typeModifier;
        this.format = format;
    }

    public ResultField(String name, int relationId, short relationAttributeNumber, TypeRef typeRef, short typeLength, int typeModifier, FieldFormat format) {
        this.name = name;
        this.relationId = relationId;
        this.relationAttributeNumber = relationAttributeNumber;
        this.typeRef = typeRef;
        this.typeLength = typeLength;
        this.typeModifier = typeModifier;
        this.format = format;
    }

    public String getName() {
        return this.name;
    }

    public int getRelationId() {
        return this.relationId;
    }

    public short getRelationAttributeNumber() {
        return this.relationAttributeNumber;
    }

    public TypeRef getTypeRef() {
        return this.typeRef;
    }

    public void setTypeRef(TypeRef typeRef) {
        this.typeRef = typeRef;
    }

    public short getTypeLength() {
        return this.typeLength;
    }

    public int getTypeModifier() {
        return this.typeModifier;
    }

    public void setFormat(FieldFormat v) {
        this.format = v;
    }

    @Override
    public FieldFormat getFormat() {
        return this.format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultField that = (ResultField)o;
        return this.relationId == that.relationId && this.relationAttributeNumber == that.relationAttributeNumber && this.typeLength == that.typeLength && this.typeModifier == that.typeModifier && Objects.equals(this.name, that.name) && Objects.equals(this.typeRef, that.typeRef) && this.format == that.format;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.relationId, this.relationAttributeNumber, this.typeRef, this.typeLength, this.typeModifier, this.format);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name);
        if (this.relationId != 0) {
            sb.append(String.format(" (%s:%d)", this.relationId, this.relationAttributeNumber));
        }
        sb.append(" : ");
        sb.append(this.typeRef != null ? this.typeRef.toString() : "<unknown>");
        return sb.toString();
    }
}

